package betterwithmods.common.world.gen.feature;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBloodLog;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

import java.util.Random;

public class WorldGenBloodTree extends WorldGenAbstractTree {
    private IBlockState log = BWMBlocks.BLOOD_LOG.func_176223_P();
    private IBlockState leaves = BWMBlocks.BLOOD_LEAVES.func_176223_P().func_177226_a(BlockLeaves.field_176237_a, true);

    public WorldGenBloodTree() {
        super(true);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = 5 + rand.nextInt(4);

        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int i = pos.func_177956_o(); i <= pos.func_177956_o() + height + 1; i++) {
                int range = i == pos.func_177956_o() ? 0 : i <= pos.func_177956_o() + 1 + height - 2 ? 2 : 1;

                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();

                for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range && flag; x++) {
                    for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range && flag; z++) {
                        if (i >= 0 && i < world.func_72800_K()) {
                            if (!this.isReplaceable(world, mut.func_181079_c(x, i, z)))
                                flag = false;
                        } else {
                            flag = false;
                        }
                    }
                }
            }

            if (!flag)
                return false;
            else {
                boolean isSustained = world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)BWMBlocks.BLOOD_SAPLING);

                if (isSustained && pos.func_177956_o() < world.func_72800_K() - height - 1) {
                    world.func_180495_p(pos.func_177977_b()).func_177230_c().onPlantGrow(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), pos);

                    for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; y++) {
                        int w = y - (pos.func_177956_o() + height);
                        int width = 1 - w / 2;

                        for(int x = pos.func_177958_n() - width; x <= pos.func_177958_n() + width; ++x) {
                            int xWide = x - pos.func_177958_n();
                            for(int z = pos.func_177952_p() - width; z <= pos.func_177952_p() + width; ++z) {
                                int zWide = z - pos.func_177952_p();

                                if(Math.abs(xWide) != width || Math.abs(zWide) != width || rand.nextInt(2) != 0 && w != 0) {
                                    BlockPos leafPos = new BlockPos(x, y, z);
                                    IBlockState leafState = world.func_180495_p(leafPos);
                                    if(leafState.func_177230_c().isAir(leafState, world, leafPos)) {
                                        this.func_175903_a(world, leafPos, leaves);
                                    }
                                }
                            }
                        }
                    }

                    for(int y = 0; y < height; ++y)
                    {
                        BlockPos up = pos.func_177981_b(y);
                        IBlockState logState = world.func_180495_p(up);
                        if(logState.func_177230_c().isAir(logState, world, up) || logState.func_177230_c().isLeaves(logState, world, up))
                        {
                            if (y > height - 4) {
                                this.func_175903_a(world, up, log.func_177226_a(BlockBloodLog.EXPANDABLE, world.field_73011_w.func_177495_o()));
                                int face = rand.nextInt(6);
                                if (face > 1) {
                                    EnumFacing facing = EnumFacing.func_82600_a(face);
                                    for (int i = 0; i < 1 + rand.nextInt(2); i++) {
                                        generateBranch(world, up.func_177967_a(facing, i), facing);
                                    }
                                }
                            }
                            else
                                this.func_175903_a(world, up, log);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void generateBranch(World world, BlockPos pos, EnumFacing facing) {
        if (this.isReplaceable(world, pos)) {
            BlockPos check = pos.func_177972_a(facing);
            IBlockState checkState = world.func_180495_p(check);
            if (canOverwrite(checkState, world, check)) {
                world.func_175656_a(check, log.func_177226_a(BlockBloodLog.EXPANDABLE, world.field_73011_w.func_177495_o()).func_177226_a(BlockLog.field_176299_a, BlockLog.EnumAxis.func_176870_a(facing.func_176740_k())));
            }
            generateLeafExpansion(world, check, facing.func_176740_k());
            generateLeafExpansion(world, check.func_177972_a(facing), facing.func_176740_k());
        }
    }

    private void generateLeafExpansion(World world, BlockPos pos, EnumFacing.Axis axis) {
        for (int i = -1; i <= 1; i++) {
            for (int j = -1; j <= 1; j++) {
                BlockPos offset;
                if (axis == EnumFacing.Axis.X)
                    offset = pos.func_177982_a(0, i, j);
                else if (axis == EnumFacing.Axis.Y)
                    offset = pos.func_177982_a(i, 0, j);
                else
                    offset = pos.func_177982_a(i, j, 0);
                if (canOverwrite(world.func_180495_p(offset), world, offset)) {
                    world.func_175656_a(offset, leaves);
                }
            }
        }
    }

    @Override
    public boolean func_150523_a(Block block) {
        return super.func_150523_a(block) || block == BWMBlocks.BLOOD_LOG;
    }

    private boolean canOverwrite(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        return block.func_176200_f(world, pos) || block.isLeaves(state, world, pos);
    }
}
