package betterwithmods.common.world;

import betterwithmods.module.GlobalConfig;
import com.google.common.collect.Sets;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

import java.util.HashMap;
import java.util.Random;
import java.util.Set;

/**
 * Created by blueyu2 on 11/27/16.
 */
public class BWMapGenScatteredFeature extends MapGenScatteredFeature {
    public static HashMap<String, Set<Biome>> STRUCTURE_BIOMES = new HashMap<>();

    static {
        STRUCTURE_BIOMES.put("WitchHut", Sets.newHashSet(Biomes.field_76780_h, Biomes.field_150599_m, Biomes.field_150585_R, Biomes.field_185430_ab, Biomes.field_76770_e));
        STRUCTURE_BIOMES.put("SandTemple", Sets.newHashSet(Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R, Biomes.field_150588_X, Biomes.field_150589_Z));
        STRUCTURE_BIOMES.put("Igloo", Sets.newHashSet(Biomes.field_76774_n, Biomes.field_185445_W, Biomes.field_76775_o, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_185431_ac));
        STRUCTURE_BIOMES.put("StoneTemple", Sets.newHashSet(Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_76772_c, Biomes.field_185432_ad, Biomes.field_76767_f));
    }

    public static StructureComponent getComponent(World world, Random random, int chunkX, int chunkZ, Biome biome) {
        if (GlobalConfig.debug)
            System.out.printf("/tp %s ~ %s\n", chunkX * 16, chunkZ * 16);
        for (String structure : STRUCTURE_BIOMES.keySet()) {
            if (STRUCTURE_BIOMES.get(structure).contains(biome)) {
                switch (structure) {
                    case "WitchHut":
                        return new BWComponentScatteredFeaturePieces.SwampHut(random, chunkX * 16, chunkZ * 16);
                    case "SandTemple":
                        return new BWComponentScatteredFeaturePieces.DesertPyramid(random, chunkX * 16, chunkZ * 16);
                    case "Igloo":
                        return new ComponentScatteredFeaturePieces.Igloo(random, chunkX * 16, chunkZ * 16);
                    case "StoneTemple":
                        return new BWComponentScatteredFeaturePieces.JunglePyramid(random, chunkX * 16, chunkZ * 16);
                }
            }
        }
        return null;
    }

    @Override
    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new BWMapGenScatteredFeature.Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start extends MapGenScatteredFeature.Start {
        public Start() {
        }

        Start(World worldIn, Random random, int chunkX, int chunkZ) {
            this(worldIn, random, chunkX, chunkZ, worldIn.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        Start(World worldIn, Random random, int chunkX, int chunkZ, Biome biomeIn) {
            StructureComponent component = getComponent(worldIn, random, chunkX, chunkZ, biomeIn);
            if (component != null)
                field_75075_a.add(component);
            this.func_75072_c();
        }
    }
}
