package betterwithmods.common.world;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.module.hardcore.world.HCStructures;
import net.minecraft.block.*;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

import java.util.Random;

/**
 * Created by blueyu2 on 11/27/16.
 */
public class BWComponentScatteredFeaturePieces {
    public static class DesertPyramid extends ComponentScatteredFeaturePieces.DesertPyramid {
        private int worldX, worldZ;

        public DesertPyramid() {
        }

        DesertPyramid(Random random, int x, int z) {
            super(random, x, z);
            this.worldX = x;
            this.worldZ = z;
        }

        @Override
        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            boolean result = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn);

            //Replace clay with obsidian
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 10, 0, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 10, 0, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 9, 0, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 11, 0, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 8, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 12, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 7, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 13, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 9, 0, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 11, 0, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 10, 0, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 10, 0, 13, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 10, 0, 10, structureBoundingBoxIn);
            for (int j2 = 0; j2 <= this.field_74939_a - 1; j2 += this.field_74939_a - 1) {
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 2, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 3, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 4, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 4, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 6, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 6, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 7, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 7, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), j2, 7, 3, structureBoundingBoxIn);
            }
            for (int k2 = 2; k2 <= this.field_74939_a - 3; k2 += this.field_74939_a - 3 - 2) {
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2 - 1, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2 + 1, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2 - 1, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2 + 1, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2 - 1, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), k2 + 1, 7, 0, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 9, 5, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150343_Z.func_176223_P(), 11, 5, 0, structureBoundingBoxIn);

            //Replace Pressure Plate
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 10, -11, 10, structureBoundingBoxIn);

            if (HCStructures.isInRadius(worldIn, worldX, worldZ)) {
                //Dig hole
                this.setAir(worldIn, 10, 0, 10, structureBoundingBoxIn);
                this.setAir(worldIn, 11, 0, 10, structureBoundingBoxIn);
                this.setAir(worldIn, 10, 0, 9, structureBoundingBoxIn);
                this.setAir(worldIn, 10, -11, 10, structureBoundingBoxIn);
                for (int x = 0; x < 3; x++) {
                    for (int z = 0; z < 3; z++) {
                        this.setAir(worldIn, 9 + x, -12, 9 + z, structureBoundingBoxIn);
                        this.setAir(worldIn, 9 + x, -13, 9 + z, structureBoundingBoxIn);
                    }
                }

                //Create ladder
                for (int i = 0; i >= -13; i--)
                    this.func_175811_a(worldIn, Blocks.field_150468_ap.func_176223_P().func_177226_a(BlockLadder.field_176382_a, EnumFacing.WEST), 11, i, 9, structureBoundingBoxIn);

                //Remove chest loot
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    int k1 = enumfacing.func_82601_c() * 2;
                    int l1 = enumfacing.func_82599_e() * 2;
                    TileEntity tileentity = worldIn.func_175625_s(new BlockPos(this.func_74865_a(10 + k1, 10 + l1), this.func_74862_a(-11), this.func_74873_b(10 + k1, 10 + l1)));
                    if (tileentity instanceof TileEntityChest)
                        ((TileEntityChest) tileentity).func_189404_a(null, randomIn.nextLong());
                }
            } else
                this.func_175811_a(worldIn, Blocks.field_150381_bn.func_176223_P(), 10, 1, 10, structureBoundingBoxIn);

            return result;
        }

        private void setAir(World world, int x, int y, int z, StructureBoundingBox structureBoundingBox) {
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, y, z, structureBoundingBox);
        }
    }

    public static class SwampHut extends ComponentScatteredFeaturePieces.SwampHut {
        private boolean hasWitch;

        public SwampHut() {
        }

        public SwampHut(Random random, int x, int y) {
            super(random, x, y);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Witch", this.hasWitch);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager template) {
            super.func_143011_b(tagCompound, template);
            this.hasWitch = tagCompound.func_74767_n("Witch");
        }

        @Override
        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.func_74935_a(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 5, 1, 7, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 2, 5, 4, 7, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 4, 1, 0, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 2, 2, 3, 3, 2, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 3, 1, 3, 6, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 2, 3, 5, 3, 6, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 2, 7, 4, 3, 7, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 2, 1, 3, 2, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 2, 5, 3, 2, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 7, 1, 3, 7, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 7, 5, 3, 7, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 3, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 3, 3, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 3, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 3, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 3, 5, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150457_bL.func_176223_P().func_177226_a(BlockFlowerPot.field_176443_b, BlockFlowerPot.EnumFlowerType.MUSHROOM_RED), 1, 3, 5, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 3, 2, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150383_bp.func_176223_P(), 4, 2, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 2, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 2, 1, structureBoundingBoxIn);
                IBlockState iblockstate = Blocks.field_150485_bF.func_176223_P().func_177226_a(BlockStairs.field_176309_a, EnumFacing.NORTH);
                IBlockState iblockstate1 = Blocks.field_150485_bF.func_176223_P().func_177226_a(BlockStairs.field_176309_a, EnumFacing.EAST);
                IBlockState iblockstate2 = Blocks.field_150485_bF.func_176223_P().func_177226_a(BlockStairs.field_176309_a, EnumFacing.WEST);
                IBlockState iblockstate3 = Blocks.field_150485_bF.func_176223_P().func_177226_a(BlockStairs.field_176309_a, EnumFacing.SOUTH);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 6, 4, 1, iblockstate, iblockstate, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 2, 0, 4, 7, iblockstate1, iblockstate1, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 4, 2, 6, 4, 7, iblockstate2, iblockstate2, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 8, 6, 4, 8, iblockstate3, iblockstate3, false);

                for (int i = 2; i <= 7; i += 5) {
                    for (int j = 1; j <= 5; j += 4) {
                        this.func_175808_b(worldIn, Blocks.field_150364_r.func_176223_P(), j, -1, i, structureBoundingBoxIn);
                    }
                }

                if (!this.hasWitch) {
                    int amount = randomIn.nextInt(3);
                    for (int i = 0; i < amount + 1; i++) {
                        int x = this.func_74865_a(i * 3, 5);
                        int y = this.func_74862_a(2);
                        int z = this.func_74873_b(i * 3, 5);

                        if (structureBoundingBoxIn.func_175898_b(new BlockPos(x, y, z))) {
                            EntityWitch entitywitch = new EntityWitch(worldIn);
                            entitywitch.func_70012_b((double) x + 0.5D, (double) y, (double) z + 0.5D, 0.0F, 0.0F);
                            entitywitch.func_180482_a(worldIn.func_175649_E(new BlockPos(x, y, z)), null);
                            entitywitch.func_110163_bv();
                            worldIn.func_72838_d(entitywitch);
                        }
                    }
                    this.hasWitch = true;
                }
            }

            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150382_bo.func_176223_P(), 2, 3, 6, structureBoundingBoxIn);

            return true;
        }
    }

    public static class JunglePyramid extends ComponentScatteredFeaturePieces.JunglePyramid {
        private int worldX, worldZ;

        public JunglePyramid() {
        }

        JunglePyramid(Random rand, int x, int z) {
            super(rand, x, z);
            this.worldX = x;
            this.worldZ = z;
        }

        @Override
        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            boolean result = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BWMBlocks.AESTHETIC.func_176223_P().func_177226_a(BlockAesthetic.TYPE, BlockAesthetic.EnumType.CHOPBLOCKBLOOD), 5, 4, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BWMBlocks.AESTHETIC.func_176223_P().func_177226_a(BlockAesthetic.TYPE, BlockAesthetic.EnumType.CHOPBLOCKBLOOD), 6, 4, 11, structureBoundingBoxIn);
            this.setAir(worldIn, 6, 3, 10, structureBoundingBoxIn);
            this.setAir(worldIn, 5, 3, 10, structureBoundingBoxIn);

            if (HCStructures.isInRadius(worldIn, worldX, worldZ)) {
                //Remove hooks
                this.setAir(worldIn, 1, -3, 8, structureBoundingBoxIn);
                this.setAir(worldIn, 4, -3, 8, structureBoundingBoxIn);
                //Remove tripwire
                this.setAir(worldIn, 2, -3, 8, structureBoundingBoxIn);
                this.setAir(worldIn, 3, -3, 8, structureBoundingBoxIn);
                //Re-add hooks
                this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a(BlockTripWireHook.field_176264_a, EnumFacing.EAST), 1, -3, 8, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a(BlockTripWireHook.field_176264_a, EnumFacing.WEST), 4, -3, 8, structureBoundingBoxIn);

                //Remove hooks
                this.setAir(worldIn, 7, -3, 1, structureBoundingBoxIn);
                this.setAir(worldIn, 7, -3, 5, structureBoundingBoxIn);
                //Remove tripwire
                this.setAir(worldIn, 7, -3, 2, structureBoundingBoxIn);
                this.setAir(worldIn, 7, -3, 3, structureBoundingBoxIn);
                this.setAir(worldIn, 7, -3, 4, structureBoundingBoxIn);
                //Re-add hooks
                this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a(BlockTripWireHook.field_176264_a, EnumFacing.NORTH), 7, -3, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a(BlockTripWireHook.field_176264_a, EnumFacing.SOUTH), 7, -3, 5, structureBoundingBoxIn);

                //Remove puzzle
                this.setAir(worldIn, 9, -2, 12, structureBoundingBoxIn);
                this.setAir(worldIn, 9, -2, 11, structureBoundingBoxIn);
                this.setAir(worldIn, 9, -3, 11, structureBoundingBoxIn);

                //Remove Chest Loot
                removeChest(worldIn, 8, -3, 3, randomIn);
                removeChest(worldIn, 9, -3, 10, randomIn);
            } else {
                this.func_175811_a(worldIn, BWMBlocks.HAND_CRANK.func_176223_P(), 5, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(worldIn, BWMBlocks.COOKING_POTS.func_176223_P().func_177226_a(BlockCookingPot.TYPE,BlockCookingPot.EnumType.DRAGONVESSEL), 6, 3, 10, structureBoundingBoxIn);
            }

            return result;
        }

        private void setAir(World world, int x, int y, int z, StructureBoundingBox structureBoundingBox) {
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, y, z, structureBoundingBox);
        }

        private void removeChest(World worldIn, int x, int y, int z, Random randomIn) {
            TileEntity tileentity = worldIn.func_175625_s(new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z)));
            if (tileentity instanceof TileEntityChest)
                ((TileEntityChest) tileentity).func_189404_a(null, randomIn.nextLong());
        }
    }
}
