package betterwithmods.common.registry.crafting;

import betterwithmods.BWMod;
import com.google.common.collect.Lists;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

import java.util.List;

public class RecipeArmorDye extends IForgeRegistryEntry.Impl<IRecipe> implements IRecipe {

    private Ingredient validArmor;

    public RecipeArmorDye(Ingredient validArmor) {
        this.validArmor = validArmor;
        setRegistryName(new ResourceLocation(BWMod.MODID,"armor_dye"));
    }

    @Override
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack itemstack = ItemStack.field_190927_a;
        List<ItemStack> list = Lists.newArrayList();

        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack1 = inv.func_70301_a(i);

            if (!itemstack1.func_190926_b()) {
                if (validArmor.apply(itemstack1)) {
                    itemstack = itemstack1;
                } else {
                    if (!net.minecraftforge.oredict.DyeUtils.isDye(itemstack1)) {
                        return false;
                    }

                    list.add(itemstack1);
                }
            }
        }

        return !itemstack.func_190926_b() && !list.isEmpty();
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack itemstack = ItemStack.field_190927_a;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        ItemArmor itemarmor = null;

        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack itemstack1 = inv.func_70301_a(k);

            if (!itemstack1.func_190926_b()) {
                if (itemstack1.func_77973_b() instanceof ItemArmor) {
                    itemarmor = (ItemArmor) itemstack1.func_77973_b();

                    if (!itemstack.func_190926_b()) {
                        return ItemStack.field_190927_a;
                    }

                    itemstack = itemstack1.func_77946_l();
                    itemstack.func_190920_e(1);

                    if (itemarmor.func_82816_b_(itemstack1)) {
                        int l = itemarmor.func_82814_b(itemstack);
                        float f = (float) (l >> 16 & 255) / 255.0F;
                        float f1 = (float) (l >> 8 & 255) / 255.0F;
                        float f2 = (float) (l & 255) / 255.0F;
                        i = (int) ((float) i + Math.max(f, Math.max(f1, f2)) * 255.0F);
                        aint[0] = (int) ((float) aint[0] + f * 255.0F);
                        aint[1] = (int) ((float) aint[1] + f1 * 255.0F);
                        aint[2] = (int) ((float) aint[2] + f2 * 255.0F);
                        ++j;
                    }
                } else {
                    if (!net.minecraftforge.oredict.DyeUtils.isDye(itemstack1)) {
                        return ItemStack.field_190927_a;
                    }

                    float[] afloat = net.minecraftforge.oredict.DyeUtils.colorFromStack(itemstack1).get().func_193349_f();
                    int l1 = (int) (afloat[0] * 255.0F);
                    int i2 = (int) (afloat[1] * 255.0F);
                    int j2 = (int) (afloat[2] * 255.0F);
                    i += Math.max(l1, Math.max(i2, j2));
                    aint[0] += l1;
                    aint[1] += i2;
                    aint[2] += j2;
                    ++j;
                }
            }
        }

        if (itemarmor == null) {
            return ItemStack.field_190927_a;
        } else {
            int i1 = aint[0] / j;
            int j1 = aint[1] / j;
            int k1 = aint[2] / j;
            float f3 = (float) i / (float) j;
            float f4 = (float) Math.max(i1, Math.max(j1, k1));
            i1 = (int) ((float) i1 * f3 / f4);
            j1 = (int) ((float) j1 * f3 / f4);
            k1 = (int) ((float) k1 * f3 / f4);
            int k2 = (i1 << 8) + j1;
            k2 = (k2 << 8) + k1;
            itemarmor.func_82813_b(itemstack, k2);
            return itemstack;
        }
    }

    @Override
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList<ItemStack> nonnulllist = NonNullList.func_191197_a(inv.func_70302_i_(), ItemStack.field_190927_a);

        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, net.minecraftforge.common.ForgeHooks.getContainerItem(itemstack));
        }

        return nonnulllist;
    }

    @Override
    public boolean func_192399_d() {
        return true;
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }
}
