package betterwithmods.common.registry.crafting;


import betterwithmods.BWMod;
import betterwithmods.module.hardcore.crafting.HCFishing;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;

import static betterwithmods.module.hardcore.crafting.HCFishing.setBaited;

public class BaitingRecipe extends ToolBaseRecipe {

    public BaitingRecipe() {
        super(new ResourceLocation(BWMod.MODID,"baiting_recipe"), ItemStack.field_190927_a, HCFishing.BAIT, stack -> HCFishing.isBaited(stack, false));
        setRegistryName(func_193358_e());
    }

    public ItemStack findRod(InventoryCrafting inv) {
        for (int x = 0; x < inv.func_70302_i_(); x++) {
            ItemStack slot = inv.func_70301_a(x);
            if (isTool.test(slot)) {
                return slot;
            }
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList<ItemStack> ret = NonNullList.func_191197_a(inv.func_70302_i_(), ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); i++) {
            ret.set(i, ForgeHooks.getContainerItem(inv.func_70301_a(i)));
        }
        return ret;
    }

    @Override
    public void playSound(InventoryCrafting inv) {}

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public Pair<Float, Float> getSoundValues() {
        return null;
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack rod = findRod(inv);
        if (!rod.func_190926_b())
            return setBaited(rod.func_77946_l(), true);
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_77571_b() {
        ItemStack rod = new ItemStack(Items.field_151112_aM);
        if (!rod.func_190926_b())
            return setBaited(rod.func_77946_l(), true);
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_192399_d() {
        return true;
    }

    @Override
    public ItemStack getExampleStack() {
        return new ItemStack(Items.field_151112_aM);
    }
}
