package betterwithmods.common.registry.anvil;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import java.util.ArrayList;
import java.util.List;

public class AnvilCraftingManager {

    public static List<IRecipe> ANVIL_CRAFTING = new ArrayList<>();

    /**
     * Retrieves an ItemStack that has multiple recipes for it.
     */
    public static ItemStack findMatchingResult(InventoryCrafting inventory, World world) {
        for (IRecipe irecipe : ANVIL_CRAFTING) {
            if (irecipe.func_77569_a(inventory, world)) {
                return irecipe.func_77572_b(inventory);
            }
        }

        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            if (irecipe.func_77569_a(inventory, world)) {
                return irecipe.func_77572_b(inventory);
            }
        }

        return ItemStack.field_190927_a;
    }



    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting inventory, World craftMatrix) {

        for (IRecipe irecipe : ANVIL_CRAFTING) {
            if (irecipe.func_77569_a(inventory, craftMatrix)) {
                return irecipe.func_179532_b(inventory);
            }
        }

        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            if (irecipe.func_77569_a(inventory, craftMatrix)) {
                return irecipe.func_179532_b(inventory);
            }
        }

        NonNullList<ItemStack> nonnulllist = NonNullList.<ItemStack>func_191197_a(inventory.func_70302_i_(), ItemStack.field_190927_a);

        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, inventory.func_70301_a(i));
        }

        return nonnulllist;
    }


}
