package betterwithmods.common.registry;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.util.item.Stack;
import betterwithmods.util.item.StackMap;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

/**
 * Created by primetoxinz on 6/29/17.
 */
public class BellowsManager {

    public static final StackMap<Float> bellowing = new StackMap<>(1.0F);

    public static float getWeight(ItemStack stack) {
        return bellowing.get(stack);
    }

    public static void put(ItemStack stack, float value) {
        bellowing.put(new Stack(stack), value);
    }

    public static void put(Block stack, float value) {
        bellowing.put(new Stack(stack, 0), value);
    }

    public static void put(Item item, float value) {
        bellowing.put(item, value);
    }

    public static void put(String ore, float value) {
        bellowing.put(ore, value);
    }

    public static void postInit() {
        put(Items.field_151016_H, 3f);
        put(Items.field_151121_aF, 3f);
        put(Items.field_151148_bJ, 3f);
        put(Items.field_151098_aY, 3f);
        put(Items.field_151008_G, 3f);
        put(Items.field_151102_aT, 3f);
        put("foodFlour", 3f);
        BWOreDictionary.dustNames.forEach(stack -> put(stack.getOre(), 3f));
        put(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK), 2f);
        put(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP), 2f);
        put(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_FIBERS), 2f);
        put(BWMBlocks.HEMP, 2f);
        put(Items.field_185163_cU, 2f);
        put(Items.field_151081_bc, 2f);
        put(Items.field_151080_bb, 2f);
        put(Items.field_151014_N, 2f);
        put(Items.field_151007_F, 2f);
        put(Items.field_151100_aR, 2f);

        put(Items.field_151015_O, 1f);
        put(Items.field_151075_bm, 1f);
        put(Items.field_151032_g, 1f);
        put(Items.field_185167_i, 1f);
        put(Items.field_185166_h, 1f);
        put(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ELEMENT), 2f);
        put(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.FILAMENT), 2f);
        put(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_STRAP), 2f);

    }


}
