package betterwithmods.common.items.tools;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.items.ItemAltName;
import betterwithmods.module.gameplay.Gameplay;
import betterwithmods.module.hardcore.world.stumping.HCStumping;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * @author Koward
 */
public class ItemStumpRemover extends ItemAltName {
    public ItemStumpRemover() {
        super();
        this.func_77637_a(BWCreativeTabs.BWTAB);
        this.func_77656_e(0);
        this.func_77627_a(false);
        this.field_77777_bU = 16;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn != null) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (!playerIn.func_175151_a(pos, facing, stack)) {
                return EnumActionResult.FAIL;
            } else if (stack.func_190916_E() == 0) {
                return EnumActionResult.FAIL;
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                IBlockState below = worldIn.func_180495_p(pos.func_177977_b());
                if (worldIn.func_175623_d(pos.func_177984_a()) && HCStumping.isLog(state) && HCStumping.isSoil(below)) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187886_fs, SoundCategory.BLOCKS, 1, 1);
                        state.func_177230_c().func_180657_a(worldIn, playerIn, pos, state, null, stack);
                        worldIn.func_175698_g(pos);
                    }

                    stack.func_190918_g(1);
                    return EnumActionResult.SUCCESS;
                } else {
                    return EnumActionResult.FAIL;
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public String[] getLocations() {
        if (Gameplay.kidFriendly)
            return new String[]{"stump_remover_kf"};
        else
            return new String[]{"stump_remover"};
    }
}
