package betterwithmods.common.items.tools;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.hardcore.creatures.HCEnchanting;
import betterwithmods.util.item.ToolsManager;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.oredict.OreDictionary;

import javax.annotation.Nullable;
import java.util.Set;

public class ItemSoulforgedMattock extends ItemTool {
    private static final Set<Block> EFFECTIVE = Sets.union(ToolsManager.getEffectiveBlocks((ItemTool) BWMItems.STEEL_PICKAXE), ToolsManager.getEffectiveBlocks((ItemTool) BWMItems.STEEL_SHOVEL));

    private static final Set<Material> EFFECTIVE_MATERIALS =  Sets.newHashSet(Material.field_151576_e,Material.field_151573_f,Material.field_151574_g,
            Material.field_151578_c, Material.field_151577_b,Material.field_151571_B, Material.field_151592_s,Material.field_76233_E,Material.field_151597_y);

    public ItemSoulforgedMattock() {
        super(BWMItems.SOULFORGED_STEEL, EFFECTIVE);
        func_77637_a(BWCreativeTabs.BWTAB);
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return BWOreDictionary.listContains(repair, OreDictionary.getOres("ingotSoulforgedSteel")) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (PlayerHelper.isCurrentToolEffectiveOnBlock(stack, state, EFFECTIVE_MATERIALS))
            return field_77864_a;
        return EFFECTIVE.contains(state.func_177230_c()) ? this.field_77864_a : 1.0F;
    }

    @Override
    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of("bwmmattock", "pickaxe", "shovel");
    }

    public boolean func_150897_b(IBlockState blockIn) {
        Block block = blockIn.func_177230_c();
        return field_77862_b.func_77996_d() >= block.getHarvestLevel(blockIn);
    }


    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return HCEnchanting.canEnchantSteel(enchantment) && super.canApplyAtEnchantingTable(stack,enchantment);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return field_77862_b.func_77996_d();
    }
}
