package betterwithmods.common.items.tools;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWOreDictionary;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

import net.minecraft.item.ItemArmor.ArmorMaterial;

public class ItemLeatherTannedArmor extends BWMArmor {
    private static final ArmorMaterial LEATHER_TANNED = EnumHelper.addArmorMaterial("leather_tanned", "betterwithmods:leather_tanned", 10, new int[]{1, 2, 3, 1}, 15, SoundEvents.field_187728_s, 0.0F);

    public ItemLeatherTannedArmor(EntityEquipmentSlot equipmentSlotIn) {
        super(LEATHER_TANNED, equipmentSlotIn, "leather_tanned");
        this.func_77637_a(BWCreativeTabs.BWTAB);
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return BWOreDictionary.listContains(repair, OreDictionary.getOres("hideTanned")) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return true;
    }
}
