package betterwithmods.common.items.tools;

import betterwithmods.BWMod;
import betterwithmods.api.client.IColorable;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.client.ColorHandlers;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

import net.minecraft.item.ItemArmor.ArmorMaterial;

public class BWMArmor extends ItemArmor implements IColorable {
    private String name;

    public BWMArmor(ArmorMaterial material, EntityEquipmentSlot equipmentSlotIn, String name) {
        super(material, 2, equipmentSlotIn);
        this.name = name;
        this.func_77637_a(BWCreativeTabs.BWTAB);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return new ResourceLocation(BWMod.MODID, String.format("textures/models/armor/%s_layer_%s%s.png", this.name, (this.field_77881_a.func_188452_c() == 2 ? "2" : "1"), type != null ? "_" + type : "")).toString();
    }

    @Override
    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_74764_b("display")) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
            if (nbttagcompound1.func_150297_b("color", 3)) {
                return nbttagcompound1.func_74762_e("color");
            }
        }
        return  0x00FFFFFF;
//        return 0xa06540;
    }

    @Override
    public void func_82815_c(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
            if (nbttagcompound1.func_74764_b("color")) {
                nbttagcompound1.func_82580_o("color");
            }
        }
    }

    @Override
    public void func_82813_b(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    @Override
    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("display", 10) ? nbttagcompound.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    @Override
    public boolean hasOverlay(ItemStack stack) {
        return func_82814_b(stack) != 0x00FFFFFF;
    }

    @Override
    public IItemColor getColorHandler() {
        return ColorHandlers.armor;
    }
}
