package betterwithmods.common.items;

import betterwithmods.common.blocks.ItemBlockMeta;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

/**
 * @author Koward
 */
public class ItemSimpleSlab extends ItemBlockMeta {
    private final Block doubleSlab;

    public ItemSimpleSlab(Block block, Block doubleSlab) {
        super(block);
        this.doubleSlab = doubleSlab;
    }

    /**
     * Called when a Block is right-clicked with this Item
     */
    @Override
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn != null) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (stack.func_190916_E() != 0 && playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
                IBlockState iblockstate = worldIn.func_180495_p(pos);
                if (iblockstate.func_177230_c() != this.field_150939_a) {
                    pos = pos.func_177972_a(facing);
                    iblockstate = worldIn.func_180495_p(pos);
                }
                if (iblockstate.func_177230_c() == this.field_150939_a) {
                    IBlockState iblockstate1 = doubleSlab.func_176223_P();
                    AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d(worldIn, pos);

                    if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 11)) {
                        SoundType soundtype = this.doubleSlab.getSoundType(iblockstate1, worldIn, pos, playerIn);
                        worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
                        stack.func_190918_g(1);
                    }

                    return EnumActionResult.SUCCESS;
                }

                return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            }
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(Side.CLIENT)
    @Override
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        BlockPos blockpos = pos;
        IBlockState iblockstate = worldIn.func_180495_p(pos);

        if (iblockstate.func_177230_c() == this.field_150939_a) {
            if (side == EnumFacing.UP) {
                return true;
            }
        }

        pos = pos.func_177972_a(side);
        IBlockState iblockstate1 = worldIn.func_180495_p(pos);
        return iblockstate1.func_177230_c() == this.field_150939_a || super.func_179222_a(worldIn, blockpos, side, player, stack);
    }
}
