package betterwithmods.common.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemEdibleSeeds extends ItemFood implements net.minecraftforge.common.IPlantable
{
    private final Block crops;
    /** BlockID of the block the seeds can be planted on. */
    private final Block soilBlockID;

    public ItemEdibleSeeds(Block crops, Block soil, int amount, float saturation)
    {
        super(amount,saturation,false);
        this.crops = crops;
        this.soilBlockID = soil;
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    /**
     * Called when a Block is right-clicked with this Item
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ)
    {
        ItemStack itemstack = player.func_184586_b(hand);
        net.minecraft.block.state.IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && state.func_177230_c().canSustainPlant(state, worldIn, pos, EnumFacing.UP, this) && worldIn.func_175623_d(pos.func_177984_a()))
        {
            worldIn.func_175656_a(pos.func_177984_a(), this.crops.func_176223_P());

            if (player instanceof EntityPlayerMP)
            {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos.func_177984_a(), itemstack);
            }

            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        else
        {
            return EnumActionResult.FAIL;
        }
    }

    @Override
    public net.minecraftforge.common.EnumPlantType getPlantType(net.minecraft.world.IBlockAccess world, BlockPos pos)
    {
        return this.crops == net.minecraft.init.Blocks.field_150388_bm ? net.minecraftforge.common.EnumPlantType.Nether : net.minecraftforge.common.EnumPlantType.Crop;
    }

    @Override
    public net.minecraft.block.state.IBlockState getPlant(net.minecraft.world.IBlockAccess world, BlockPos pos)
    {
        return this.crops.func_176223_P();
    }
}
