package betterwithmods.common.items;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.entity.EntityDynamite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class ItemDynamite extends Item {
    public ItemDynamite() {
        super();
        this.func_77637_a(BWCreativeTabs.BWTAB);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {

        int flintIndex = -1;

        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); i++) {
            if (!player.field_71071_by.field_70462_a.get(i).func_190926_b() && player.field_71071_by.field_70462_a.get(i).func_77973_b() == Items.field_151033_d) {
                flintIndex = i;
                break;
            }
        }

        if (!world.field_72995_K) {
            boolean lit = false;

            if (flintIndex > -1) {
                lit = true;
                ItemStack steelStack = player.field_71071_by.func_70301_a(flintIndex);
                steelStack.func_77972_a(1, player);
                if (steelStack.func_190916_E() < 1)
                    player.field_71071_by.field_70462_a.set(flintIndex, ItemStack.field_190927_a);
            }

            player.func_184586_b(hand).func_190918_g(1);
            EntityDynamite dynamite = new EntityDynamite(world, player, new ItemStack(this, 1), lit);
            world.func_72838_d(dynamite);

            if (lit)
                world.func_184133_a(null, new BlockPos(dynamite.field_70165_t, dynamite.field_70163_u, dynamite.field_70161_v), SoundEvents.field_187904_gd, SoundCategory.AMBIENT, 1.0F, 1.0F);
            else
                world.func_184133_a(null, new BlockPos(dynamite.field_70165_t, dynamite.field_70163_u, dynamite.field_70161_v), SoundEvents.field_187737_v, SoundCategory.AMBIENT, 0.5F, 0.4F / (Item.field_77697_d.nextFloat() * 0.4F + 0.8F));
        }
        return new ActionResult<>(EnumActionResult.SUCCESS, player.func_184586_b(hand));
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a("lore.bwm:dynamite"));
    }


    @Override
    public int getEntityLifespan(ItemStack stack, World world) {
        return 6000;
    }
}
