package betterwithmods.common.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemBlockEdible extends ItemBlock {

    public final int itemUseDuration;
    private final int food;
    private final float saturation;
    private final boolean wolfFood;
    private boolean alwaysEdible;
    private PotionEffect potionId;
    private float potionProbabilty;

    public ItemBlockEdible(Block block, int amount, float saturation, boolean isWolfFood) {
        super(block);
        this.itemUseDuration = 32;
        this.food = amount;
        this.wolfFood = isWolfFood;
        this.saturation = saturation;
        this.func_77637_a(CreativeTabs.field_78039_h);
    }

    public ItemBlockEdible setPotionEffect(PotionEffect effect, float probability)
    {
        this.potionId = effect;
        this.potionProbabilty = probability;
        return this;
    }

    /**
     * Called when the player finishes using this Item (E.g. finishes eating.). Not called when the player stops using
     * the Item before the action is complete.
     */
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer) entityLiving;
            entityplayer.func_71024_bL().func_75122_a(this.food, this.saturation);
            worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5F, worldIn.field_73012_v.nextFloat() * 0.1F + 0.9F);
            this.onFoodEaten(stack, worldIn, entityplayer);
            entityplayer.func_71029_a(StatList.func_188057_b(this));

            if (entityplayer instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP) entityplayer, stack);
            }
        }

        stack.func_190918_g(1);
        return stack;
    }

    protected void onFoodEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && this.potionId != null && worldIn.field_73012_v.nextFloat() < this.potionProbabilty) {
            player.func_70690_d(new PotionEffect(this.potionId));
        }
    }


    public int func_77626_a(ItemStack stack)
    {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack)
    {
        return EnumAction.EAT;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);

        if (playerIn.func_71043_e(false)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult<>(EnumActionResult.SUCCESS, itemstack);
        } else {
            return new ActionResult<>(EnumActionResult.FAIL, itemstack);
        }
    }

}
