package betterwithmods.common.items;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMItems;
import com.google.common.collect.Lists;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

import java.util.ArrayList;
import java.util.List;

public class ItemBark extends Item implements IMultiLocations {

    public static List<String> barks = Lists.newArrayList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "bloody");

    public ItemBark() {
        super();
        this.func_77637_a(BWCreativeTabs.BWTAB);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public int getItemBurnTime(ItemStack itemStack) {
        return 25;
    }

    public static ItemStack getStack(String wood, int amount) {
        return new ItemStack(BWMItems.BARK, amount, barks.indexOf(wood));
    }

    @Override
    public String[] getLocations() {
        ArrayList<String> locations = new ArrayList<>();
        for (int i = 0; i < barks.size(); i++) {
            locations.add("bark_" + barks.get(i));
        }
        return locations.toArray(new String[locations.size()]);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab))
            for (int i = 0; i < barks.size(); i++) {
                items.add(new ItemStack(this, 1, i));
            }
    }


    @Override
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() > barks.size())
            return super.func_77658_a();
        return super.func_77658_a() + "." + barks.get(stack.func_77952_i());
    }
}
