package betterwithmods.common.items;

import betterwithmods.common.BWMItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Created by primetoxinz on 9/11/16.
 */
public class ItemArcaneScroll extends Item {



    public static ItemStack getScrollWithEnchant(Enchantment enchantment) {
        ItemStack stack = new ItemStack(BWMItems.ARCANE_SCROLL);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("enchant", Enchantment.func_185258_b(enchantment));
        stack.func_77982_d(tag);
        return stack;
    }

    public static Enchantment getEnchantment(ItemStack scroll) {
        NBTTagCompound tag = scroll.func_77978_p();
        if(tag.func_74764_b("enchant")) {
            int e = tag.func_74762_e("enchant");
            return Enchantment.func_185262_c(e);
        }
        return null;
    }

    public ItemArcaneScroll() {
        super();
        func_77627_a(true);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Enchantment enchantment : Enchantment.field_185264_b) {
                items.add(getScrollWithEnchant(enchantment));
            }
        }
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    /**
     * Return an item rarity from EnumRarity
     */
    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int id = stack.func_77978_p() != null ? stack.func_77978_p().func_74762_e("enchant") : 0;
        Enchantment enchantment = Enchantment.func_185262_c(id);
        if (enchantment != null) {
            tooltip.add(enchantment.func_77316_c(-1));
        }
    }

}
