package betterwithmods.common.entity.ai;

import betterwithmods.common.entity.EntitySpiderWeb;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.MathHelper;

/**
 * Created by primetoxinz on 4/22/17.
 */
public class ShooterSpiderWeb extends EntityAIBase {
    private EntitySpider spider;
    private EntityLivingBase target;
    private int seeTime;
    private int attackTime, maxAttackTime;
    private float radius, maxRadius;

    public ShooterSpiderWeb(EntitySpider spider, int maxAttackTime, float radius) {
        this.spider = spider;
        this.maxAttackTime = maxAttackTime;
        this.maxRadius = this.radius = radius;
        func_75248_a(3);
        this.attackTime = -1;
    }

    @Override
    public boolean func_75250_a() {
        EntityLivingBase target = spider.func_70638_az();
        if (target != null) {
            this.target = target;
            double d = spider.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
            return !(Math.sqrt(d) < 5 || target.func_70090_H() || target.field_70134_J);
        }
        return false;
    }

    @Override
    public void func_75246_d() {
        double d = spider.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
        boolean canSee = spider.func_70635_at().func_75522_a(target);
        if (d <= (maxRadius * maxRadius)) {
            spider.func_70661_as().func_75499_g();
        } else {
            spider.func_70661_as().func_75497_a(target, 1.0F);
        }
        spider.func_70671_ap().func_75651_a(target, 30.0F, 30.0F);
        if (attackTime-- == 0) {
        	if(canSee) {
		        shootWeb();
	        }
            float f = MathHelper.func_76133_a(d) / (radius);
            attackTime = MathHelper.func_76141_d(f * maxAttackTime);

        } else if (attackTime < 0) {
            float f2 = MathHelper.func_76133_a(d) / (radius);
            attackTime = MathHelper.func_76141_d(f2 * maxAttackTime);
        }
        super.func_75246_d();
    }

    @Override
    public boolean func_75253_b() {
        return this.func_75250_a() || !spider.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        target = null;
        this.attackTime = -1;
    }

    private void shootWeb() {
	    EntitySpiderWeb web = new EntitySpiderWeb(spider.func_130014_f_(), spider);
	    double d0 = target.field_70163_u;
	    double d1 = target.field_70165_t - spider.field_70165_t;
	    double d2 = d0 - web.field_70163_u;
	    double d3 = target.field_70161_v - spider.field_70161_v;
	    float f = MathHelper.func_76133_a(d1 * d1 + d3 * d3) * 0.2F;
	    web.func_70186_c(d1, d2 + (double)f, d3, 1.0F, 2);
	    spider.func_184185_a(SoundEvents.field_187886_fs, 1.0F, 1.0F / (spider.func_70681_au().nextFloat() * 0.4F + 0.8F));
	    spider.field_70170_p.func_72838_d(web);
    }
}
