package betterwithmods.common.entity.ai;

import betterwithmods.util.ReflectionLib;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

import java.util.List;
import java.util.Random;


public class EntityAIVillagerMate extends EntityAIBase {
    final World world;
    /**
     * The speed the creature moves at during mating behavior.
     */
    final double moveSpeed;
    private final EntityVillager villager;
    /**
     * Delay preventing a baby from spawning immediately when two mate-able animals find each other.
     */
    int spawnBabyDelay;
    private EntityVillager mate;

    public EntityAIVillagerMate(EntityVillager villager, double speedIn) {
        this.villager = villager;
        this.world = villager.func_130014_f_();
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
    }

    public static boolean isWillingToMate(EntityVillager villager) {
        if (villager != null) {
            return ReflectionHelper.getPrivateValue(EntityVillager.class, villager, ReflectionLib.ENTITY_VILLAGER_ISWILLINGTOMATE);
        }
        return false;
    }

    /**
     * Returns whether the EntityAIBase should begin execution.
     */
    @Override
    public boolean func_75250_a() {
        if (this.villager.func_70874_b() != 0 || this.villager.func_70681_au().nextInt(500) != 0) {
            return false;
        }
        if (!isWillingToMate(villager)) {
            return false;
        } else {
            this.mate = this.getNearbyMate();
            return this.mate != null && this.mate.func_70874_b() == 0;
        }
    }

    /**
     * Returns whether an in-progress EntityAIBase should continue executing
     */
    @Override
    public boolean func_75253_b() {
        return this.mate.func_70089_S() && isWillingToMate(mate) && this.spawnBabyDelay < 60;
    }

    /**
     * Resets the task
     */
    @Override
    public void func_75251_c() {
        this.mate = null;
        this.spawnBabyDelay = 0;
    }

    /**
     * Updates the task
     */
    @Override
    public void func_75246_d() {
        this.villager.func_70671_ap().func_75651_a(this.mate, 10.0F, (float) this.villager.func_70646_bf());
        this.villager.func_70661_as().func_75497_a(this.mate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.villager.func_70068_e(this.mate) < 9.0D) {
            this.spawnBaby();
        }
    }

    /**
     * Loops through nearby animals and finds another animal of the same type that can be mated with. Returns the first
     * valid mate found.
     */
    private EntityVillager getNearbyMate() {
        List<EntityVillager> list = this.world.func_72872_a(this.villager.getClass(), this.villager.func_174813_aQ().func_186662_g(8.0D));
        double d0 = Double.MAX_VALUE;
        EntityVillager mate = null;
        for (EntityVillager current : list) {
            if (canMateWith(this.villager, current) && this.villager.func_70068_e(current) < d0) {
                mate = current;
                d0 = this.villager.func_70068_e(current);
            }
        }
        return mate;
    }

    /**
     * Spawns a baby animal of the same type.
     */
    private void spawnBaby() {
        EntityVillager baby = this.villager.func_90011_a(this.mate);

        if (baby != null) {

            this.villager.func_70873_a(6000);
            this.mate.func_70873_a(6000);
            this.villager.func_175549_o(false);
            this.mate.func_175549_o(false);
            baby.func_70873_a(-24000);
            baby.func_70012_b(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, 0.0F, 0.0F);
            boolean profession = world.field_73012_v.nextBoolean();
            baby.setProfession(profession ? villager.getProfessionForge() : mate.getProfessionForge());
            this.world.func_72838_d(baby);
            Random random = this.villager.func_70681_au();

            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02D;
                double d1 = random.nextGaussian() * 0.02D;
                double d2 = random.nextGaussian() * 0.02D;
                double d3 = random.nextDouble() * (double) this.villager.field_70130_N * 2.0D - (double) this.villager.field_70130_N;
                double d4 = 0.5D + random.nextDouble() * (double) this.villager.field_70131_O;
                double d5 = random.nextDouble() * (double) this.villager.field_70130_N * 2.0D - (double) this.villager.field_70130_N;
                this.world.func_175688_a(EnumParticleTypes.HEART, this.villager.field_70165_t + d3, this.villager.field_70163_u + d4, this.villager.field_70161_v + d5, d0, d1, d2);
            }

            if (this.world.func_82736_K().func_82766_b("doMobLoot")) {
                this.world.func_72838_d(new EntityXPOrb(this.world, this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }

    public boolean canMateWith(EntityVillager village, EntityVillager mate) {
        return village != mate && (isWillingToMate(villager) && isWillingToMate(mate));
    }

}
