package betterwithmods.common.entity.ai;

import betterwithmods.module.tweaks.EasyBreeding;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

import java.util.List;

public class EntityAISearchFood extends EntityAIBase {
    private final EntityAnimal entity;
    private EntityItem targetItem;
    private int timeoutCounter;

    private double findRadius = 5;
    private double eatRadius = 2;

    public EntityAISearchFood(EntityAnimal creature) {
        this.entity = creature;
    }

    /**
     * Returns whether the EntityAIBase should begin execution.
     */
    @Override
    public boolean func_75250_a() {
        if (entity.func_70874_b() < 1 && !entity.func_70880_s()) {
            if (entity instanceof EntityWolf) {
                if (!((EntityWolf) entity).func_70909_n())
                    return false;
            }
            BlockPos entityPos = entity.func_180425_c();
            if (targetItem == null) {
                List<EntityItem> entityItems = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_186662_g(findRadius));
                if (!entityItems.isEmpty()) {
                    for (EntityItem item : entityItems) {
                        if (entity.func_70877_b(item.func_92059_d()) || EasyBreeding.isOtherValidFood(item.func_92059_d(), entity)) {
                            targetItem = item;
                            break;
                        }
                    }
                }
            }

            if (targetItem != null) {
                BlockPos targetPos = targetItem.func_180425_c();
                if (entityPos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) <= eatRadius && targetItem.func_92059_d().func_190916_E() > 0) {
                    processItemEating();
                    return false;
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Execute a one shot task or start executing a continuous task
     */
    @Override
    public void func_75249_e() {
        if (entity.func_70874_b() < 1 && !entity.func_70880_s()) {
            if (entity instanceof EntityWolf) {
                if (((EntityWolf) entity).func_70906_o())
                    return;
            }
            this.entity.func_70661_as().func_75492_a(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v, 1.0F);
        }
    }

    /**
     * Returns whether an in-progress EntityAIBase should continue executing
     */
    @Override
    public boolean func_75253_b() {
        if (targetItem.field_70128_L || targetItem.func_92059_d().func_190916_E() < 1) {
            BlockPos entityPos = entity.func_180425_c();
            List<EntityItem> entityItems = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_186662_g(findRadius));
            if (!entityItems.isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (entity.func_70877_b(item.func_92059_d())) {
                        targetItem = item;
                        break;
                    }
                }
            }
        }

        if (targetItem == null || targetItem.field_70128_L)
            return false;
        if (entity.func_70874_b() < 1 && !entity.func_70880_s()) {
            if (entity instanceof EntityWolf) {
                if (((EntityWolf) entity).func_70906_o())
                    return false;
            }
            if (timeoutCounter > 1200)
                return false;
            if (!this.entity.func_70661_as().func_75500_f()) {
                double sqDistToPos = this.entity.func_70092_e(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v);
                if (sqDistToPos > eatRadius)
                    return true;
            }
        }
        return false;
    }

    /**
     * Updates the task
     */
    @Override
    public void func_75246_d() {
        if (entity.func_70092_e(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v) <= eatRadius && targetItem.func_92059_d().func_190916_E() > 0) {
            processItemEating();
        } else {
            ++timeoutCounter;
            if (timeoutCounter % 40 == 0) {
                this.entity.func_70661_as().func_75492_a(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v, 1.0F);
            }
        }
    }

    private void processItemEating() {
        if (!entity.func_130014_f_().field_72995_K) {
            ItemStack foodStack = targetItem.func_92059_d();
            boolean eaten = false;
            if (entity.func_70877_b(foodStack)) {
                if (entity.func_70874_b() == 0 && !entity.func_70880_s()) {
                    eaten = true;
                    entity.func_146082_f(null);
                } else if (entity.func_70631_g_()) {
                    eaten = true;
                    entity.func_175501_a((int) ((float) (-entity.func_70874_b() / 20) * 0.1F), true);
                }
            }
            if (EasyBreeding.eatFood(foodStack, entity))
                eaten = true;
            if(eaten) {
                foodStack.func_190918_g(1);
            }
        }
    }
}
