package betterwithmods.common.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;

/**
 * The Entity will flee from threats in the opposite direction.
 *
 * @author Koward
 */
public class EntityAIFlee extends EntityAIBase {
    protected final double speed;
    private final EntityCreature theEntityCreature;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public EntityAIFlee(EntityCreature creature, double speedIn) {
        this.theEntityCreature = creature;
        this.speed = speedIn;
        this.func_75248_a(1);
    }

    /**
     * Returns whether the EntityAIBase should begin execution.
     */
    @Override
    public boolean func_75250_a() {
        Vec3d vec3d = null;

        if (this.theEntityCreature.func_70027_ad()) {
            vec3d = RandomPositionGenerator.func_75463_a(this.theEntityCreature, 5, 4);
        } else if (this.theEntityCreature.func_70643_av() != null) {
            vec3d = RandomPositionGenerator.func_75461_b(this.theEntityCreature, 5, 0,
                    new Vec3d(this.theEntityCreature.func_70643_av().field_70165_t, this.theEntityCreature.func_70643_av().field_70163_u, this.theEntityCreature.func_70643_av().field_70161_v));
        }

        if (vec3d != null) {
            this.randPosX = vec3d.field_72450_a;
            this.randPosY = vec3d.field_72448_b;
            this.randPosZ = vec3d.field_72449_c;
            return true;
        } else {
            return false;
        }
    }

    /**
     * Execute a one shot task or start executing a continuous task
     */
    @Override
    public void func_75249_e() {
        this.theEntityCreature.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    /**
     * Returns whether an in-progress EntityAIBase should continue executing
     */
    @Override
    public boolean func_75253_b() {
        if (!this.theEntityCreature.func_70661_as().func_75500_f() && this.theEntityCreature.func_70643_av() != null) {
            EntityLivingBase target = this.theEntityCreature.func_70643_av();

            if (target == null) {
                return true;
            }

            double sqDistToPos = this.theEntityCreature.func_70092_e(this.randPosX, this.randPosY, this.randPosZ);

            if (sqDistToPos > 2.0D) {
                double sqDistToTarget = this.theEntityCreature.func_70068_e(target);
                double sqDistOfTargetToPos = target.func_70092_e(this.randPosX, this.randPosY, this.randPosZ);

                if (sqDistToTarget < sqDistOfTargetToPos) {
                    return true;
                }
            }
        }

        return false;
    }
}
