package betterwithmods.common.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

import java.util.List;
import java.util.Optional;

/**
 * Created by primetoxinz on 4/22/17.
 */
public class EntityAIEatFood extends EntityAIBase {
    private EntityCreature entity;
    private Ingredient validItem;
    private EntityItem targetItem;
    private int cooldown;

    public EntityAIEatFood(EntityCreature creature, Ingredient validItem) {
        this.entity = creature;
        this.validItem = validItem;
    }

    public Optional<EntityItem> getTargetItem(List<EntityItem> items) {
        if (items.isEmpty())
            return Optional.empty();
        EntityItem target = null;
        for (EntityItem item : items) {
            if (validItem.test(item.func_92059_d())) {
                target = item;
                break;
            }
        }
        return Optional.ofNullable(target);
    }

    @Override
    public void func_75251_c() {
        targetItem = null;
    }

    @Override
    public boolean func_75250_a() {
        if(cooldown > 0)
            return false;
        BlockPos entityPos = entity.func_180425_c();
        if (targetItem == null) {
            List<EntityItem> entityItems = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_72321_a(2, 2,2));
            targetItem = getTargetItem(entityItems).orElse(null);
        }

        if (targetItem != null) {
            BlockPos targetPos = targetItem.func_180425_c();
            if (entityPos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) <= 2D) {
                processItemEating();
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_75253_b() {
       return func_75250_a();
    }

    private void processItemEating() {
        if(targetItem != null) {
            ItemStack foodStack = targetItem.func_92059_d().func_77979_a(1);
            entity.func_184185_a(SoundEvents.field_187739_dZ, 1.0F, (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2F + 1.0F);
            foodStack.func_190918_g(1);
            cooldown = 500;
        }
    }
}
