package betterwithmods.common.entity.ai;

import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;

/**
 * Purpose:
 *
 * @author primetoxinz
 * @version 11/20/16
 */
public class EndermanAgro extends EntityAINearestAttackableTarget<EntityPlayer> {
    public final EntityEnderman enderman;
    public EntityPlayer player;
    public int aggroTime;
    public int teleportTime;

    public EndermanAgro(EntityEnderman enderman) {
        super(enderman, EntityPlayer.class, false);
        this.enderman = enderman;
    }

    /**
     * Returns whether the EntityAIBase should begin execution.
     */
    public boolean func_75250_a() {
        double d0 = this.func_111175_f();
        this.player = this.enderman.func_130014_f_().func_184150_a(this.enderman.field_70165_t, this.enderman.field_70163_u, this.enderman.field_70161_v, d0, d0, null, player -> player != null && enderman.func_70821_d(player));
        return this.player != null;
    }

    /**
     * Execute a one shot task or start executing a continuous task
     */
    public void func_75249_e() {
        this.aggroTime = 5;
        this.teleportTime = 0;
    }

    /**
     * Resets the task
     */
    public void func_75251_c() {
        this.player = null;
        super.func_75251_c();
    }

    /**
     * Returns whether an in-progress EntityAIBase should continue executing
     */
    @Override
    public boolean func_75253_b() {
        if (this.player != null) {
            if (!enderman.func_70821_d(player)) {
                return false;
            } else {
                this.enderman.func_70625_a(this.player, 10.0F, 10.0F);
                return true;
            }
        } else {
            return this.field_75309_a != null && this.field_75309_a.func_70089_S() || super.func_75253_b();
        }
    }

    /**
     * Updates the task
     */
    public void func_75246_d() {

        if (this.player != null) {
            if (--this.aggroTime <= 0) {
                this.field_75309_a = this.player;
                this.player = null;
                super.func_75249_e();
            }
        } else {
            if (this.field_75309_a != null) {
                if (enderman.func_70821_d(field_75309_a)) {
                    if (this.field_75309_a.func_70068_e(this.enderman) < 16.0D) {
                        this.enderman.func_70820_n();
                    }
                    this.teleportTime = 0;
                } else if (this.field_75309_a.func_70068_e(this.enderman) > 256.0D && this.teleportTime++ >= 30 && this.enderman.func_70816_c(this.field_75309_a)) {
                    this.teleportTime = 0;
                }
            }

            super.func_75246_d();
        }
    }
}
