package betterwithmods.common.entity.ai;

import betterwithmods.module.hardcore.creatures.chicken.EggLayer;
import betterwithmods.module.hardcore.creatures.chicken.HCChickens;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

import java.util.List;

public class AIFoodEggLayer extends EntityAIBase {
    private final EntityAnimal entity;
    private final EggLayer layer;
    private EntityItem targetItem;
    private int timeoutCounter;

    public AIFoodEggLayer(EntityAnimal creature) {
        this.entity = creature;
        this.layer = creature.getCapability(EggLayer.EGG_LAYER_CAP, EnumFacing.DOWN);
    }

    /**
     * Returns whether the EntityAIBase should begin execution.
     */
    @Override
    public boolean func_75250_a() {
        if (entity.func_70874_b() < 1 && !layer.isFeed()) {
            BlockPos entityPos = entity.func_180425_c();
            if (targetItem == null) {
                List<EntityItem> entityItems = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_72321_a(5, 5, 5));
                if (!entityItems.isEmpty()) {
                    for (EntityItem item : entityItems) {
                        if (layer.isBreedingItem(item.func_92059_d())) {
                            targetItem = item;
                            break;
                        }
                    }
                }
            }
            if (targetItem != null) {
                BlockPos targetPos = targetItem.func_180425_c();
                if (entityPos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) <= 2D && targetItem.func_92059_d().func_190916_E() > 0) {
                    processItemEating();
                    return false;
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Execute a one shot task or start executing a continuous task
     */
    @Override
    public void func_75249_e() {
        if (entity.func_70874_b() < 1 && !entity.func_70880_s()) {
            if (entity instanceof EntityWolf) {
                if (((EntityWolf) entity).func_70906_o())
                    return;
            }
            this.entity.func_70661_as().func_75492_a(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v, 1.0F);
        }
    }

    /**
     * Returns whether an in-progress EntityAIBase should continue executing
     */
    @Override
    public boolean func_75253_b() {
        if (targetItem.field_70128_L || targetItem.func_92059_d().func_190916_E() < 1) {
            BlockPos entityPos = entity.func_180425_c();
            List<EntityItem> entityItems = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_72321_a(5, 5, 5));
            if (!entityItems.isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (layer.isBreedingItem(item.func_92059_d())) {
                        targetItem = item;
                        break;
                    }
                }
            }
        }
        if (targetItem == null || targetItem.field_70128_L)
            return false;
        if (entity.func_70874_b() < 1 && !layer.isFeed()) {
            if (timeoutCounter > 1200)
                return false;
            if (!this.entity.func_70661_as().func_75500_f()) {
                double sqDistToPos = this.entity.func_70092_e(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v);
                if (sqDistToPos > 2.0D)
                    return true;
            }
        }
        return false;
    }

    /**
     * Updates the task
     */
    @Override
    public void func_75246_d() {
        if (entity.func_70092_e(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v) <= 2.0D && targetItem.func_92059_d().func_190916_E() > 0) {
            processItemEating();
        } else {
            ++timeoutCounter;
            if (timeoutCounter % 40 == 0) {
                this.entity.func_70661_as().func_75492_a(targetItem.field_70165_t, targetItem.field_70163_u, targetItem.field_70161_v, 1.0F);
            }
        }
    }

    private void processItemEating() {
        if (!entity.func_130014_f_().field_72995_K) {
            ItemStack foodStack = targetItem.func_92059_d().func_77979_a(1);
            boolean bred = false;
            if (layer.isBreedingItem(foodStack)) {
                if (entity.func_70874_b() == 0 && !layer.isFeed()) {
                    bred = true;
                    layer.feed(entity, foodStack);
                }
            }
            if (!bred) {
                targetItem.func_92059_d().func_190917_f(1);
            } else if (targetItem.func_92059_d().func_190916_E() < 1) {
                targetItem.func_70106_y();
            }
        }
    }
}
