package betterwithmods.common.entity;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBloodSapling;
import betterwithmods.common.blocks.BlockNetherGrowth;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

/**
 * Created by primetoxinz on 6/13/17.
 */
public class EntityUrn extends EntitySnowball {

    public EntityUrn(World worldIn) {
        super(worldIn);
    }

    public EntityUrn(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public EntityUrn(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @SideOnly(Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3)
        {
            for (int i = 0; i < 8; ++i)
            {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1D, 0.5D, 0.1D, Block.func_176210_f(BWMBlocks.URN.func_176223_P().func_177226_a(BlockUrn.TYPE, BlockUrn.EnumType.FULL)));
            }
        }
    }

    /**
     * Called when this EntityThrowable hits a block or entity.
     */
    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {


            if (result.field_72313_a != RayTraceResult.Type.MISS) {
                BlockPos pos = result.field_72313_a == RayTraceResult.Type.ENTITY ? result.field_72308_g.func_180425_c() : result.func_178782_a();
                field_70170_p.func_184133_a(null, func_180425_c(), SoundEvents.field_187825_fO, SoundCategory.PLAYERS, 0.5F, 0.4F / (field_70146_Z.nextFloat() * 0.4F + 0.8F));

                Iterable<BlockPos> pool = BlockPos.PooledMutableBlockPos.func_177980_a(pos.func_177982_a(-3, -3, -3), pos.func_177982_a(3, 3, 3));
                boolean grew = false;
                for (BlockPos p : pool) {
                    IBlockState state = field_70170_p.func_180495_p(p);
                    if (state.func_177230_c() == BWMBlocks.NETHER_GROWTH) {
                        BlockNetherGrowth b = (BlockNetherGrowth) state.func_177230_c();
                        for(int i =0;i<10;i++)
                            b.grow(field_70170_p, p, state, field_70146_Z);
                        grew = true;
                    }
                    if (state.func_177230_c() == BWMBlocks.BLOOD_SAPLING) {
                        BlockBloodSapling sapling = (BlockBloodSapling)state.func_177230_c();
                        if (sapling.generateTree(field_70170_p, p, field_70170_p.func_180495_p(p), field_70146_Z))
                            grew = true;
                    }
                }
                if (!grew) {
                    WorldUtils.spawnGhast(field_70170_p, pos);
                }
            }
            this.field_70170_p.func_72960_a(this, (byte) 3);
            this.func_70106_y();
        }
    }
}
