package betterwithmods.common.entity;

import betterwithmods.BWMod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.*;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

import javax.annotation.Nullable;

/**
 * Created by primetoxinz on 9/21/16.
 */
public class EntityShearedCreeper extends EntityMob {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a(new ResourceLocation(BWMod.MODID, "entity/sheared_creeper"));

    public EntityShearedCreeper(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, new EntityAIAvoidEntity<>(this, EntityOcelot.class, 6.0F, 1.0D, 1.2D));
        this.field_70714_bg.func_75776_a(4, new EntityAIAttackMelee(this, 1.0D, false));
        this.field_70714_bg.func_75776_a(5, new EntityAIWander(this, 0.8D));
        this.field_70714_bg.func_75776_a(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0F));
        this.field_70714_bg.func_75776_a(6, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAINearestAttackableTarget<>(this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, new EntityAIHurtByTarget(this, false));
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25D);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187570_aq;
    }

    @Nullable
    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187570_aq;
    }

    @Override
    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2F + 1.5F;
    }


    @Override
    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public void func_70645_a(DamageSource cause)
    {
        super.func_70645_a(cause);

        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))
        {
            if (cause.func_76346_g() instanceof EntitySkeleton)
            {
                int i = Item.func_150891_b(Items.field_151096_cd);
                int j = Item.func_150891_b(Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d(k), 1);
            }
            else if (cause.func_76346_g() instanceof EntityCreeper && cause.func_76346_g() != this && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && ((EntityCreeper)cause.func_76346_g()).func_70650_aV())
            {
                ((EntityCreeper)cause.func_76346_g()).func_175493_co();
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0F);
            }
        }
    }


}
