package betterwithmods.common.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

import java.util.HashMap;
import java.util.List;

import static net.minecraft.util.EnumFacing.*;

import net.minecraft.util.EnumFacing.AxisDirection;

/**
 * Created by primetoxinz on 9/5/16.
 */
public class EntityMiningCharge extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityMiningCharge.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FACING = EntityDataManager.func_187226_a(EntityMiningCharge.class, DataSerializers.field_187192_b);
    private EntityLivingBase igniter;
    /**
     * How long the fuse is
     */
    private int fuse;
    private EnumFacing facing;
    private HashMap<Block, IBlockState> dropMap = new HashMap<Block, IBlockState>() {{
        put(Blocks.field_150347_e, Blocks.field_150351_n.func_176223_P());
        put(Blocks.field_150351_n, Blocks.field_150354_m.func_176223_P());
    }};

    public EntityMiningCharge(World worldIn) {
        super(worldIn);
        this.fuse = 80;
        this.field_70156_m = true;
        this.func_70105_a(0.98F, 0.98F);
    }

    public EntityMiningCharge(World worldIn, double x, double y, double z, EntityLivingBase igniter, EnumFacing facing) {
        this(worldIn);
        setFacing(facing);
        this.func_70107_b(x, y, z);
        this.setFuse(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.igniter = igniter;
        func_189654_d(facing != UP);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, 80);
        this.field_70180_af.func_187214_a(FACING, EnumFacing.NORTH.func_176745_a());
    }

    /**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    /**
     * Returns true if other Entities should be prevented from moving through this Entity.
     */
    @Override
    public boolean func_70067_L() {
        return false;
    }

    /**
     * Called to update the entity's position/logic.
     */
    @Override
    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.03999999910593033D;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);


        --this.fuse;

        if (this.fuse <= 0) {
            this.func_70106_y();

            if (!this.func_130014_f_().field_72995_K) {
                this.explode();
            }
        } else {
            this.func_70072_I();
            this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5D, this.field_70161_v, 0.0D, 0.0D, 0.0D);
        }
    }

    private void explode() {
        this.func_130014_f_().func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0F, (1.0F + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.2F) * 0.7F);
        this.func_130014_f_().func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0D, 0.0D, 0.0D);
        BlockPos pos = func_180425_c();
        EnumFacing facing = this.facing.func_176734_d();
        for (int k = 0; k <= 3; k++) {
            int dir = facing.func_176743_c() == AxisDirection.POSITIVE ? 1 : -1;
            if (k < 3) {
                for (int i = -1; i <= 1; i++) {
                    for (int j = -1; j <= 1; j++) {
                        if (facing == UP || facing == DOWN)
                            explodeBlock(func_130014_f_(), pos.func_177982_a(i, dir * k, j));
                        else if (facing == NORTH || facing == SOUTH)
                            explodeBlock(func_130014_f_(), pos.func_177982_a(i, j, dir * k));
                        else if (facing == EAST || facing == WEST)
                            explodeBlock(func_130014_f_(), pos.func_177982_a(dir * k, i, j));
                    }
                }
            } else {
                if (facing == UP || facing == DOWN)
                    explodeBlock(func_130014_f_(), pos.func_177982_a(0, dir * k, 0));
                else if (facing == NORTH || facing == SOUTH)
                    explodeBlock(func_130014_f_(), pos.func_177982_a(0, 0, dir * k));
                else if (facing == EAST || facing == WEST)
                    explodeBlock(func_130014_f_(), pos.func_177982_a(dir * k, 0, 0));
            }
        }
        List<EntityLivingBase> entities = func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72321_a(5, 5, 5));
        entities.forEach(entity -> entity.func_70097_a(DamageSource.func_188405_b(igniter), 45f));
    }

    private void explodeBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        float resistance = state.func_177230_c().getExplosionResistance(world, pos, null, null);
        if (resistance < 100) {
            Explosion explosion = new Explosion(world, igniter, field_70165_t, field_70163_u, field_70161_v, 0, false, false);
            if (state.func_177230_c().func_149659_a(explosion)) {
                if (dropMap.containsKey(state.func_177230_c())) {
                    IBlockState drop = dropMap.get(state.func_177230_c());
                    drop.func_177230_c().func_176226_b(world, pos, drop, 0);
                } else
                    state.func_177230_c().func_176226_b(world, pos, state, 0);
            }
            state.func_177230_c().onBlockExploded(world, pos, explosion);
            world.func_175698_g(pos);
        }
    }

    /**
     * (abstract) Protected HELPER method to write subclass entity data to NBT.
     */
    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short) this.getFuse());
        compound.func_74774_a("Facing", (byte) this.getFacing().func_176745_a());
    }

    /**
     * (abstract) Protected HELPER method to read subclass entity data from NBT.
     */
    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
        this.setFacing(compound.func_74771_c("Facing"));
    }

    /**
     * returns null or the entityliving it was placed or ignited by
     */
    public EntityLivingBase getTntPlacedBy() {
        return this.igniter;
    }

    @Override
    public float func_70047_e() {
        return 0.0F;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDM();
        }
        if (FACING.equals(key)) {
            this.facing = EnumFacing.func_82600_a(getFacingDM());
        }
    }

    public void setFacing(EnumFacing facing) {
        this.field_70180_af.func_187227_b(FACING, facing.func_176745_a());
        this.facing = facing;
    }

    public int getFuseDM() {
        return this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFacingDM() {
        return this.field_70180_af.func_187225_a(FACING);
    }

    public EnumFacing getFacing() {
        return facing;
    }

    public void setFacing(int facing) {
        setFacing(EnumFacing.func_82600_a(facing));
    }

    public int getFuse() {
        return this.fuse;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, fuseIn);
        this.fuse = fuseIn;
    }
}
