package betterwithmods.common.entity;

import betterwithmods.util.WorldUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

/**
 * Created by primetoxinz on 7/23/17.
 */
public class EntityHCFishHook extends EntityFishHook implements IEntityAdditionalSpawnData {

    public EntityHCFishHook(World world) {
        super(world, null);
    }

    public EntityHCFishHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn, fishingPlayer);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public void func_190620_n() {
        if (field_146042_b == null)
            return;
        super.func_190620_n();
    }

    @Override
    public void func_190626_a(EntityPlayer angler) {
        this.func_70105_a(0.25F, 0.25F);
        this.field_70158_ak = true;
        this.field_146042_b = angler;
        if (this.field_146042_b != null)
            this.field_146042_b.field_71104_cf = this;
    }

    @Override
    public void func_190621_a(BlockPos pos) {
        WorldServer worldserver = (WorldServer) this.field_70170_p;

        //minutes
        double min = 1;
        if (WorldUtils.isTimeFrame(field_70170_p, WorldUtils.TimeFrame.NIGHT)) {
            min *= 2; //2
        }

        if (worldserver.func_175727_C(pos.func_177984_a())) {
            min *= 0.75; //1.5
        }

        if (WorldUtils.isMoonPhase(field_70170_p, WorldUtils.MoonPhase.Full)) {
            min /= 2; //.75
        }

        if (WorldUtils.isTimeFrame(worldserver, WorldUtils.TimeFrame.DAWN) || WorldUtils.isTimeFrame(worldserver, WorldUtils.TimeFrame.DUSK)) {
            min /= 2;
        }

        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;

            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
            } else {
                this.field_70181_x -= 0.2D * (double) this.field_70146_Z.nextFloat() * (double) this.field_70146_Z.nextFloat();
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= 1;

            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float) ((double) this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0D);
                float f = this.field_146054_aA * 0.017453292F;
                float f1 = MathHelper.func_76126_a(f);
                float f2 = MathHelper.func_76134_b(f);
                double d0 = this.field_70165_t + (double) (f1 * (float) this.field_146038_az * 0.1F);
                double d1 = (double) ((float) MathHelper.func_76128_c(this.func_174813_aQ().field_72338_b) + 1.0F);
                double d2 = this.field_70161_v + (double) (f2 * (float) this.field_146038_az * 0.1F);
                Block block = worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0D, d2)).func_177230_c();

                if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15F) {
                        worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, d0, d1 - 0.10000000149011612D, d2, 1, (double) f1, 0.1D, (double) f2, 0.0D);
                    }

                    float f3 = f1 * 0.04F;
                    float f4 = f2 * 0.04F;
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double) f4, 0.01D, (double) (-f3), 1.0D);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double) (-f4), 0.01D, (double) f3, 1.0D);
                }
            } else {
                this.field_70181_x = (double) (-0.4F * MathHelper.func_151240_a(this.field_70146_Z, 0.6F, 1.0F));
                this.func_184185_a(SoundEvents.field_187609_F, 0.25F, 1.0F + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4F);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5D;
                worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, d3, this.field_70161_v, (int) (1.0F + this.field_70130_N * 20.0F), (double) this.field_70130_N, 0.0D, (double) this.field_70130_N, 0.20000000298023224D);
                worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, d3, this.field_70161_v, (int) (1.0F + this.field_70130_N * 20.0F), (double) this.field_70130_N, 0.0D, (double) this.field_70130_N, 0.20000000298023224D);
                this.field_146045_ax = MathHelper.func_76136_a(this.field_70146_Z, 20, 40);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= 1;
            float f5 = 0.15F;

            if (this.field_146040_ay < 20) {
                f5 = (float) ((double) f5 + (double) (20 - this.field_146040_ay) * 0.05D);
            } else if (this.field_146040_ay < 40) {
                f5 = (float) ((double) f5 + (double) (40 - this.field_146040_ay) * 0.02D);
            } else if (this.field_146040_ay < 60) {
                f5 = (float) ((double) f5 + (double) (60 - this.field_146040_ay) * 0.01D);
            }

            if (this.field_70146_Z.nextFloat() < f5) {
                float f6 = MathHelper.func_151240_a(this.field_70146_Z, 0.0F, 360.0F) * 0.017453292F;
                float f7 = MathHelper.func_151240_a(this.field_70146_Z, 25.0F, 60.0F);
                double d4 = this.field_70165_t + (double) (MathHelper.func_76126_a(f6) * f7 * 0.1F);
                double d5 = (double) ((float) MathHelper.func_76128_c(this.func_174813_aQ().field_72338_b) + 1.0F);
                double d6 = this.field_70161_v + (double) (MathHelper.func_76134_b(f6) * f7 * 0.1F);
                Block block1 = worldserver.func_180495_p(new BlockPos((int) d4, (int) d5 - 1, (int) d6)).func_177230_c();

                if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i) {
                    worldserver.func_175739_a(EnumParticleTypes.WATER_SPLASH, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), 0.10000000149011612D, 0.0D, 0.10000000149011612D, 0.0D);
                }
            }

            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a(this.field_70146_Z, 0.0F, 360.0F);
                this.field_146038_az = MathHelper.func_76136_a(this.field_70146_Z, 20, 80);
            }
        } else {
            if (field_146042_b.func_184812_l_()) {
                this.field_146040_ay = 1;
            } else {
                int modifer = 20 * 60;
                this.field_146040_ay = MathHelper.func_76136_a(this.field_70146_Z, (int) (min * (modifer)), (int) ((min + 2) * (modifer)));
                this.field_146040_ay = Math.max(1200, this.field_146040_ay - (this.field_191519_ax * 1200));
            }

        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        if (field_146042_b != null)
            buffer.writeInt(field_146042_b.func_145782_y());
        else
            buffer.writeInt(0);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        field_146042_b = (EntityPlayer) Minecraft.func_71410_x().field_71441_e.func_73045_a(additionalData.readInt());
    }
}

