package betterwithmods.common.entity;

import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class EntityFallingGourd extends EntityFallingBlock {
    private static final DataParameter<Integer> FALLBLOCK = EntityDataManager.func_187226_a(EntityFallingGourd.class, DataSerializers.field_187192_b);
    private ItemStack seedStack = ItemStack.field_190927_a;
    private SoundEvent shatterSound = SoundEvents.field_187886_fs;
    private boolean smashOnImpact = false;

    @SuppressWarnings("unused")
    public EntityFallingGourd(World worldIn) {
        super(worldIn);
    }

    public EntityFallingGourd(World worldIn, double x, double y, double z, IBlockState fallingBlockState) {
        super(worldIn, x, y, z, fallingBlockState);
        setBlock(fallingBlockState);
    }

    @Override
    public void func_70071_h_() {
        IBlockState fallblock = func_175131_l();
        Block block = fallblock.func_177230_c();
        if (fallblock.func_185904_a() == Material.field_151579_a) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            BlockPos blockpos1;
            if (this.field_145812_b++ == 0) {
                blockpos1 = new BlockPos(this);
                if (this.func_130014_f_().func_180495_p(blockpos1).func_177230_c() == block) {
                    this.func_130014_f_().func_175698_g(blockpos1);
                } else if (!this.func_130014_f_().field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }

            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.03999999910593033D;
            }

            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.9800000190734863D;
            this.field_70181_x *= 0.9800000190734863D;
            this.field_70179_y *= 0.9800000190734863D;
            if (!this.func_130014_f_().field_72995_K) {
                blockpos1 = new BlockPos(this);
                if (field_70122_E) {
                    IBlockState iblockstate = field_70170_p.func_180495_p(blockpos1);
                    if (field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - 0.009999999776482582D, this.field_70161_v)) && BlockFalling.func_185759_i(this.func_130014_f_().func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.01D, this.field_70161_v)))) {
                        field_70122_E = false;
                        return;
                    }

                    this.field_70159_w *= 0.7D;
                    this.field_70179_y *= 0.7D;
                    this.field_70181_x *= -0.5D;
                    if (10 + field_70146_Z.nextInt(7) <= this.field_145812_b)
                        smashOnImpact = true;
                    if (iblockstate.func_177230_c() != Blocks.field_180384_M) {
                        if (!smashOnImpact && this.func_130014_f_().func_190527_a(block, blockpos1, true, EnumFacing.UP, null) && !BlockFalling.func_185759_i(this.func_130014_f_().func_180495_p(blockpos1.func_177977_b())) && this.func_130014_f_().func_180501_a(blockpos1, fallblock, 3)) {
                            this.func_70106_y();
                            if (block instanceof BlockFalling) {
                                ((BlockFalling) block).func_176502_a_(this.func_130014_f_(), blockpos1, fallblock, iblockstate);
                            }
                        } else {
                            this.shatter();
                        }
                    }
                } /*else if (fallTime > 100 && !world.isRemote && (blockpos1.getY() < 1 || blockpos1.getY() > 256) || fallTime > 600) {
                    this.shatter();
                }*/
            }
        }
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f(distance - 1.0F);

        if (i > 0 && !field_70170_p.field_72995_K)
        {
            List<Entity> list = Lists.newArrayList(this.field_70170_p.func_72839_b(this, this.func_174813_aQ()));

            for (Entity entity : list)
            {
                entity.func_70097_a(DamageSource.field_82729_p, 1);
                smashOnImpact = true;
            }
        }
    }

    public void shatter() {
        if (!func_130014_f_().field_72995_K) {
            func_184185_a(shatterSound, 0.8F, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2F + 1.0F) / 0.8F); //slime sound i guess
            IBlockState fallblock = func_175131_l();
            if (fallblock != null)
                func_130014_f_().func_175718_b(2001, new BlockPos(this), Block.func_176210_f(fallblock));

            if (!seedStack.func_190926_b()) {
                ItemStack seeds = seedStack.func_77946_l();
                seeds.func_190920_e(field_70146_Z.nextInt(3) + 1);
                if (this.field_145813_c && this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_70099_a(seeds, 0.0F);
                }
            }
            this.func_70106_y();
        }
    }

    @Nullable
    @Override
    public IBlockState func_175131_l() {
        return Block.func_176220_d(field_70180_af.func_187225_a(FALLBLOCK));
    }

    public void setBlock(IBlockState blockstate) {
        field_70180_af.func_187227_b(FALLBLOCK, Block.func_176210_f(blockstate));
    }

    public ItemStack getSeedStack() {
        return seedStack;
    }

    public void setSeedStack(ItemStack stack) {
        seedStack = stack;
    }

    public void setShatterSound(SoundEvent sound) {
        shatterSound = sound;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        field_70180_af.func_187214_a(FALLBLOCK, 0);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        setBlock(field_175132_d);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        field_175132_d = func_175131_l();
        super.func_70014_b(compound);
    }
}
