package betterwithmods.common.entity;

import betterwithmods.common.BWMItems;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fluids.IFluidBlock;

public class EntityDynamite extends Entity implements IProjectile {
    private static final float pi = 3.141593F;
    public ItemStack stack;
    private int fuse;

    public EntityDynamite(World world) {
        this(world,0,0,0, new ItemStack(BWMItems.DYNAMITE));
    }

    public EntityDynamite(World world, double xPos, double yPos, double zPos, ItemStack stack) {
        super(world);
        this.func_70105_a(0.25F, 0.4F);
        this.func_70107_b(xPos, yPos, zPos);
        this.stack = stack;
        this.fuse = 100;
        this.field_70156_m = true;
        this.stack = stack;
        this.field_70178_ae = true;
    }

    public EntityDynamite(World world, EntityLivingBase owner, ItemStack stack, boolean isLit) {
        this(world);
        this.func_70012_b(owner.field_70165_t, owner.field_70163_u + owner.func_70047_e(), owner.field_70161_v, owner.field_70177_z, owner.field_70125_A);
        this.field_70165_t -= MathHelper.func_76134_b(this.field_70177_z / 180.0F * pi) * 0.16F;
        this.field_70163_u -= 0.1D;
        this.field_70161_v -= MathHelper.func_76126_a(this.field_70177_z / 180.0F * pi) * 0.16F;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = (-MathHelper.func_76126_a(this.field_70177_z / 180.0F * pi) * MathHelper.func_76134_b(this.field_70125_A / 180.0F * pi) * 0.4F);
        this.field_70179_y = (MathHelper.func_76134_b(this.field_70177_z / 180.0F * pi) * MathHelper.func_76134_b(this.field_70125_A / 180.0F * pi) * 0.4F);
        this.field_70181_x = (-MathHelper.func_76126_a(this.field_70125_A / 180.0F * pi) * 0.4F);
        this.stack = stack;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.75F, 1.0F);
        if (isLit)
            fuse = 100;
    }

    @Override
    public void func_70071_h_() {
        int x = MathHelper.func_76128_c(this.field_70165_t);
        int y = MathHelper.func_76128_c(this.field_70163_u);
        int z = MathHelper.func_76128_c(this.field_70161_v);

        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();

        if (block == Blocks.field_150356_k || block == Blocks.field_150353_l)
            this.fuse = 1;
        else if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock) block;
            if (fluid.getFluid().getTemperature() > 1299)
                this.fuse = 1;
        }

        if (this.fuse > 0) {
            if (!this.func_130014_f_().field_72995_K && this.fuse % 20 == 0)
                this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0F, 1.0F);
            this.fuse--;
            if (this.fuse == 0) {
                this.func_70106_y();
                if (!this.func_130014_f_().field_72995_K) {
                    explode();
                }
            }
            if (this.func_130014_f_().field_72995_K) {
                float smokeOffset = 0.25F;
                if ((block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h) ||
                        (block instanceof IFluidBlock && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h)) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * smokeOffset, this.field_70163_u - this.field_70181_x * smokeOffset, this.field_70161_v - this.field_70179_y * smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - this.field_70159_w * smokeOffset, this.field_70163_u - this.field_70181_x * smokeOffset, this.field_70161_v - this.field_70179_y * smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else if (block instanceof BlockFire) {
            this.fuse = 100;
            this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0F, 1.0F);
        } else if (this.field_70122_E) {
            if (Math.abs(this.field_70159_w) < 0.01D && Math.abs(this.field_70181_x) < 0.01D && Math.abs(this.field_70179_y) < 0.01D) {
                if (!this.func_130014_f_().field_72995_K) {
                    convertToItem();
                    return;
                }
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04D;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98D;
        this.field_70181_x *= 0.98D;
        this.field_70179_y *= 0.98D;

        if (this.field_70122_E) {
            this.field_70159_w *= 0.7D;
            this.field_70179_y *= 0.7D;
            this.field_70181_x *= -0.5D;
        }

        this.func_70066_B();
    }

    @Override
    public void func_70186_c(double dX, double dY,
                      double dZ, float angle, float f) {
        float sqrt = MathHelper.func_76133_a(dX * dX + dY * dY + dZ * dZ);
        dX /= sqrt;
        dY /= sqrt;
        dZ /= sqrt;
        dX += this.field_70146_Z.nextGaussian() * 0.0075D * f;
        dY += this.field_70146_Z.nextGaussian() * 0.0075D * f;
        dZ += this.field_70146_Z.nextGaussian() * 0.0075D * f;
        dX *= angle;
        dY *= angle;
        dZ *= angle;
        this.field_70159_w = dX;
        this.field_70181_x = dY;
        this.field_70179_y = dZ;
        float pitch = MathHelper.func_76133_a(dX * dX + dZ * dZ);
        this.field_70126_B = (this.field_70177_z = (float) (Math.atan2(dX, dZ) * 180.0D / pi));
        this.field_70127_C = (this.field_70125_A = (float) (Math.atan2(dY, pitch) * 180.0D / pi));
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b("Fuse"))
            fuse = tag.func_74762_e("Fuse");
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        if (fuse > 0)
            tag.func_74768_a("Fuse", fuse);
    }

    public void explode() {
        float intensity = 1.5F;
        this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, intensity, true);
        int x = MathHelper.func_76128_c(this.field_70165_t);
        int y = MathHelper.func_76128_c(this.field_70163_u);
        int z = MathHelper.func_76128_c(this.field_70161_v);
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h)
            redneckFishing(x, y, z);
    }

    private void redneckFishing(int x, int y, int z) {
        for (int i = x - 3; i < x + 4; i++) {
            for (int j = y - 2; j < y + 4; j++) {
                for (int k = z - 3; k < z + 4; k++) {
                    if (isWaterBlock(i, j, k)) {
                        if (this.field_70146_Z.nextInt(20) == 0)
                            spawnDeadFish(i, j, k);
                    }
                }
            }
        }
    }

    private boolean isWaterBlock(int x, int y, int z) {
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        return block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h;
    }

    private void spawnDeadFish(int x, int y, int z) {
        LootContext.Builder build = new LootContext.Builder((WorldServer) this.func_130014_f_());
        for (ItemStack stack : this.func_130014_f_().func_184146_ak().func_186521_a(LootTableList.field_186390_ao).func_186462_a(this.func_130014_f_().field_73012_v, build.func_186471_a())) {
            EntityItem item = new EntityItem(this.func_130014_f_(), x, y, z, stack.func_77946_l());
            this.func_130014_f_().func_72838_d(item);
        }
    }

    private void convertToItem() {
        InvUtils.ejectStack(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.stack);
        this.func_70106_y();
    }

}
