package betterwithmods.common.blocks.tile;

/**
 * This class was created by <Vazkii>. It's distributed as
 * part of the Botania Mod. Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 * <p>
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 * <p>
 * File Created @ [Jun 7, 2014, 2:21:28 PM (GMT)]
 */


import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockKiln;
import betterwithmods.common.registry.block.recipe.KilnRecipe;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import java.util.Random;

//TODO REDO THIS.
public class TileKiln extends TileBasic {

    private static final String TAG_CAMO = "camo";
    private static final String TAG_CAMO_META = "camoMeta";

    public IBlockState camoState;


    public void kiln(World world, BlockPos pos, Random rand) {
        if (func_145838_q() instanceof BlockKiln) {
            BlockKiln block = (BlockKiln) func_145838_q();
            BlockPos kilnPos = pos.func_177977_b();
            int oldCookTime = block.getCookCounter(world, kilnPos);
            int currentTickRate = 20;

            IBlockState state = world.func_180495_p(pos);
            KilnRecipe recipe = BWRegistry.KILN.findRecipe(world, pos, state).orElse(null);

            if (recipe != null) {
                int newCookTime = oldCookTime + 1;
                if (newCookTime > 7) {
                    newCookTime = 0;
                    recipe.craftRecipe(world, pos, rand, state);
                    block.setCookCounter(world, kilnPos, 0);
                } else {
                    if (newCookTime > 0) {
                        world.func_175715_c(0, pos, newCookTime + 2);
                    }
                    currentTickRate = block.calculateTickRate(world, kilnPos);
                }
                block.setCookCounter(world, kilnPos, newCookTime);
                if (newCookTime == 0) {
                    world.func_175715_c(0, pos, -1);
                    block.setCookCounter(world, kilnPos, 0);
                    world.func_180497_b(kilnPos, block, currentTickRate, 5);
                }
            } else if (oldCookTime != 0) {
                world.func_175715_c(0, pos, -1);
                block.setCookCounter(world, kilnPos, 0);
                world.func_180497_b(kilnPos, block, currentTickRate, 5);
            } else {
                world.func_175715_c(0, pos, -1);
            }
        }

    }

    public void setCamoState(IBlockState camoState) {
        this.camoState = camoState;
        func_70296_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (camoState != null) {
            compound.func_74778_a(TAG_CAMO, Block.field_149771_c.func_177774_c(camoState.func_177230_c()).toString());
            compound.func_74768_a(TAG_CAMO_META, camoState.func_177230_c().func_176201_c(camoState));
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        Block b = Block.func_149684_b(compound.func_74779_i(TAG_CAMO));
        if (b != null) {
            camoState = b.func_176203_a(compound.func_74762_e(TAG_CAMO_META));
        }
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        field_145850_b.func_175704_b(field_174879_c, field_174879_c);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onBreak() {
        Block block = camoState.func_177230_c();
        int meta = block.func_176201_c(camoState);
        InvUtils.ejectStackWithOffset(field_145850_b, field_174879_c, new ItemStack(block, 1, meta));
    }
}
