package betterwithmods.common.blocks.tile;

import betterwithmods.api.capabilities.SteamCapability;
import betterwithmods.api.tile.ISteamPower;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TileEntitySteamPipe extends TileEntity implements ITickable, ISteamPower {
    private int heatUnits = 0;
    private int steamPower = 0;
    private boolean update = false;
    private Random rand = new Random();

    @Override
    public void func_73660_a() {
        if (update) {
            calculateSteamPower(null);
            update = false;
        }
        List<EnumFacing> low = findLowestTransfer(false);
        if (!low.isEmpty()) {
            int exits = low.size();
            EnumFacing facing = low.get(rand.nextInt(exits));
            TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(facing));
            if (tile != null) {
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                    //Insert item transfer code here.
                }
            }
        }
    }

    private List<EnumFacing> findLowestTransfer(boolean heat) {
        List<EnumFacing> dirs = new ArrayList<>();
        if (!heat) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(facing));
                if (tile != null) {
                    if (isPipelineExit(tile, facing)) {
                        dirs.add(facing);
                    } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) && tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) {
                        if (tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing).canTransferItem()) {
                            if (facing == EnumFacing.DOWN) {
                                if (tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing).getSteamPower(facing.func_176734_d()) == 0)
                                    dirs.add(facing);
                            } else if (tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing).getSteamPower(facing.func_176734_d()) < steamPower)
                                dirs.add(facing);
                        }
                    }
                }
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(facing));
                if (tile != null) {
                    if (tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) {
                        if (facing != EnumFacing.DOWN && tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing).getSteamPower(facing.func_176734_d()) < steamPower) {
                            dirs.add(facing);
                        }
                    }
                }
            }
        }
        return dirs;
    }

    @Override
    public void calculateSteamPower(EnumFacing facing) {
        int currentPower = steamPower;
        int highestNeighbor = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(side));
            if (side == EnumFacing.UP)
                continue;
            if (tile != null) {
                if (tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side)) {
                    if (tile.getCapability(SteamCapability.STEAM_CAPABILITY, side).getSteamPower(side.func_176734_d()) > highestNeighbor)
                        highestNeighbor = tile.getCapability(SteamCapability.STEAM_CAPABILITY, side).getSteamPower(side.func_176734_d());
                }
            }
        }

        if (highestNeighbor > currentPower) {
            currentPower = highestNeighbor - 1;
        } else if (currentPower > 0) {
            --currentPower;
        } else {
            currentPower = 0;
        }

        if (steamPower != currentPower) {
            steamPower = currentPower;

            for (EnumFacing side : EnumFacing.field_82609_l) {
                TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(side));
                if (tile != null) {
                    if (tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side)) {
                        tile.getCapability(SteamCapability.STEAM_CAPABILITY, side).setSteamUpdate(true);
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        readSteamPower(tag);
    }

    @Override
    public void readSteamPower(NBTTagCompound tag) {
        if (tag.func_74764_b("Steam"))
            this.steamPower = tag.func_74762_e("Steam");
        if (tag.func_74764_b("Heat"))
            this.heatUnits = tag.func_74762_e("Heat");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        writeSteamPower(t);
        return t;
    }

    @Override
    public NBTTagCompound writeSteamPower(NBTTagCompound tag) {
        tag.func_74768_a("Steam", this.steamPower);
        tag.func_74768_a("Heat", this.heatUnits);
        return tag;
    }

    @Override
    public int getHeatUnits(EnumFacing facing) {
        int transfer = findLowestTransfer(true).size();
        if (transfer > 0)
            return heatUnits / transfer;
        return heatUnits;
    }

    @Override
    public int getSteamPower(EnumFacing facing) {
        return steamPower;
    }

    @Override
    public void calculateHeatUnits() {
        List<EnumFacing> low = findLowestTransfer(true);
        heatUnits = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!low.contains(facing)) {
                TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(facing));
                if (tile != null) {
                    if (tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) {
                        heatUnits = tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing).getHeatUnits(facing.func_176734_d());
                    }
                }
            }
        }
    }

    @Override
    public void setSteamUpdate(boolean update) {
        if (this.update != update)
            this.update = update;
    }

    private boolean isPipelineExit(TileEntity tile, EnumFacing facing) {
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) && !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) && !(tile instanceof TileEntityHopper) && !(tile instanceof TileEntityFilteredHopper);
    }

    @Override
    public boolean canTransferItem() {
        return true;
    }
}
