package betterwithmods.common.blocks.tile;

import betterwithmods.api.capabilities.SteamCapability;
import betterwithmods.api.tile.ISteamPower;
import betterwithmods.common.fluid.BWFluidRegistry;
import betterwithmods.common.fluid.FluidTankRestricted;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

import java.util.ArrayList;
import java.util.List;

public class TileEntitySteamBoiler extends TileEntity implements ITickable, ISteamPower {

    private int heatUnits = 0;
    private boolean isActive = false;
    private int heatingProgress = 0;
    private byte update = 0;
    private FluidTankRestricted water = new FluidTankRestricted(new FluidStack(FluidRegistry.WATER, 4000), 4000);
    private FluidTankRestricted steam = new FluidTankRestricted(new FluidStack(BWFluidRegistry.STEAM, 4000), 4000);

    @Override
    public void func_73660_a() {
        if (heatUnits > 0) {
            if (steam.getFluidAmount() < steam.getCapacity()) {
                if (water.getFluidAmount() > 0) {
                    FluidStack evaporate = water.getFluid();
                    if (evaporate != null && evaporate.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000))) {
                        int transfer = Math.min(heatUnits, steam.getCapacity() - steam.getFluidAmount());
                        if (transfer != 0) {
                            if (water.drain(transfer, false) != null) {
                                transfer = water.drain(transfer, true).amount;
                                steam.fill(new FluidStack(BWFluidRegistry.STEAM, transfer), true);
                            }
                        }
                    }
                }
            }
        }
        update++;
        if (update > 19) {
            update = 0;
            calculateSteamPower(null);
            calculateHeatUnits();
        }
    }

    @Override
    public void calculateSteamPower(EnumFacing facing) {
        boolean active = steam.getFluidAmount() > 0;
        if (isActive != active) {
            isActive = active;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (side != EnumFacing.DOWN) {
                    TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(side));
                    if (tile != null) {
                        if (tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side)) {
                            tile.getCapability(SteamCapability.STEAM_CAPABILITY, side).setSteamUpdate(true);
                        }
                    }
                }
            }
        }
    }

    @Override
    public int getSteamPower(EnumFacing facing) {
        return isActive ? 16 : 0;
    }

    @Override
    public void calculateHeatUnits() {
        BlockPos pos = this.field_174879_c.func_177972_a(EnumFacing.DOWN);
        int heat = 0;
        BWMHeatRegistry.HeatSource source = BWMHeatRegistry.get(field_145850_b,pos);
        if(source != null)
            heat = source.getHeat();
        if (heat > 0) {
            for (int x = -1; x < 2; x++) {
                for (int z = -1; z < 2; z++) {
                    if (x == 0 && z == 0)
                        continue;
                    BlockPos check = pos.func_177982_a(x, 0, z);
                    heat += BWMHeatRegistry.getHeat(field_145850_b,pos);
                }
            }
        }
        if (heat != heatUnits)
            heatUnits = heat;
    }

    @Override
    public int getHeatUnits(EnumFacing facing) {
        int exits = getExits().size();
        if (exits > 0)
            return this.heatUnits / exits;
        return this.heatUnits;
    }

    private List<EnumFacing> getExits() {
        List<EnumFacing> exits = new ArrayList<>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing != EnumFacing.DOWN) {
                TileEntity tile = func_145831_w().func_175625_s(field_174879_c.func_177972_a(facing));
                if (tile != null) {
                    if (tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) {
                        exits.add(facing);
                    }
                }
            }
        }
        return exits;
    }

    public FluidTank getFluidTankFromIndex(int index) {
        if (index == 1)
            return steam;
        return water;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        readSteamPower(tag);
    }

    @Override
    public void readSteamPower(NBTTagCompound tag) {
        if (tag.func_74764_b("Active"))
            isActive = tag.func_74767_n("Active");
        if (tag.func_74764_b("Heat"))
            heatUnits = tag.func_74762_e("Heat");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        writeSteamPower(t);
        return t;
    }

    @Override
    public NBTTagCompound writeSteamPower(NBTTagCompound tag) {
        tag.func_74757_a("Active", isActive);
        tag.func_74768_a("Heat", heatUnits);
        return tag;
    }

    @Override
    public void setSteamUpdate(boolean update) {
    }

    @Override
    public boolean canTransferItem() {
        return false;
    }
}
