package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.BlockInfernalEnchanter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

/**
 * Created by primetoxinz on 9/11/16.
 */
public class TileEntityInfernalEnchanter extends TileBasic implements ITickable {
    private final static int RADIUS = 8;
    public int bookcaseCount;
    private boolean active;

    private static float getPower(World world, BlockPos pos) {
        float power = ForgeHooks.getEnchantPower(world, pos);
        if (power > 0) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (!world.func_180495_p(pos.func_177972_a(facing)).func_185904_a().func_76220_a())
                    return power;
            }
        }
        return 0;
    }

    @Override
    public void func_73660_a() {

        if (func_145831_w().func_82737_E() % 20 == 0) {
            bookcaseCount = 0;
            for (int x = -RADIUS; x <= RADIUS; x++) {
                for (int y = -RADIUS; y <= RADIUS; y++) {
                    for (int z = -RADIUS; z <= RADIUS; z++) {
                        BlockPos current = field_174879_c.func_177982_a(x, y, z);
                        float power = getPower(field_145850_b, current);
                        if (power > 0) {
                            bookcaseCount += power;
                        }
                    }
                }
            }
        }

        if (func_145831_w().func_82737_E() % 5 == 0) {
            boolean players = !field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(field_174879_c).func_186662_g(3)).isEmpty();
            if (active != players) {
                active = players;
                if(active)
                    field_145850_b.func_184133_a(null, field_174879_c, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1, 1);
            }
            IBlockState state = field_145850_b.func_180495_p(field_174879_c);
            if (active) {
                field_145850_b.func_175656_a(field_174879_c, state.func_177226_a(BlockInfernalEnchanter.ACTIVE,true));
                int x = field_174879_c.func_177958_n(), y = field_174879_c.func_177956_o(), z = field_174879_c.func_177952_p();
                func_145831_w().func_175688_a(EnumParticleTypes.FLAME, x + .125, y + .9, z + .125, 0, 0, 0);
                func_145831_w().func_175688_a(EnumParticleTypes.FLAME, x + .875, y + .9, z + .125, 0, 0, 0);
                func_145831_w().func_175688_a(EnumParticleTypes.FLAME, x + .875, y + .9, z + .875, 0, 0, 0);
                func_145831_w().func_175688_a(EnumParticleTypes.FLAME, x + .125, y + .9, z + .875, 0, 0, 0);
            } else {
                field_145850_b.func_175656_a(field_174879_c, state.func_177226_a(BlockInfernalEnchanter.ACTIVE,false));
            }
        }
    }

    public int getBookcaseCount() {
        return bookcaseCount;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("bookcaseCount", bookcaseCount);
        compound.func_74757_a("active", active);
        return super.func_189515_b(compound);

    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        bookcaseCount = compound.func_74762_e("bookcaseCount");
        active = compound.func_74767_n("active");
        super.func_145839_a(compound);
    }

    public String getName() {
        return "bwm.infernalenchanter";
    }

    public boolean isActive() {
        return active;
    }
}
