package betterwithmods.common.blocks.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Purpose:
 *
 * @author primetoxinz
 * @version 3/20/17
 */
public class TileEntityDragonVessel extends TileBasic implements ITickable, IMechanicalPower, ICrankable {
    private final int MAX_EXPERIENCE = 1395;
    private int experience;
    private int maxDist = 5;
    private EnumFacing facing = EnumFacing.UP;
    public TileEntityDragonVessel() {
    }

    private int addExperience(int xp)  {
        if(this.experience >= MAX_EXPERIENCE)
            return xp;
        if(this.experience < MAX_EXPERIENCE-xp) {
            this.experience += xp;
            return 0;
        } else if( this.experience >= MAX_EXPERIENCE-xp) {
            int newXp = xp - (MAX_EXPERIENCE-experience);
            this.experience += newXp;
            return xp - newXp;
        }
        return xp;
    }
    private void hooverXP(EntityXPOrb entity) {
        if (!field_145850_b.field_72995_K && !entity.field_70128_L) {
            int xpValue = entity.func_70526_d();
            int xpDrained = MathHelper.func_76125_a(MAX_EXPERIENCE - experience,0,xpValue);
            addExperience(xpValue);
            xpValue -= xpDrained;
            func_70296_d();
            if (xpValue > 0) {
                entity.field_70530_e = xpValue;
                release(entity);
            } else {
                entity.func_70106_y();
            }
        }
    }

    @Override
    public void func_73660_a() {
        if (this.getBlockWorld().field_72995_K)
            return;
        if (this.getBlockWorld().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockCookingPot) {
            IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);

            if (!isPowered()) {
                this.facing = EnumFacing.UP;
                AxisAlignedBB box = new AxisAlignedBB(field_174879_c).func_186662_g(maxDist);
                List<EntityXPOrb> xp = field_145850_b.func_72872_a(EntityXPOrb.class, box);
                for (EntityXPOrb entity : xp) {
                    double xDist = (func_174877_v().func_177958_n() + 0.5D - entity.field_70165_t);
                    double yDist = (func_174877_v().func_177956_o() + 0.5D - entity.field_70163_u);
                    double zDist = (func_174877_v().func_177952_p() + 0.5D - entity.field_70161_v);

                    double totalDistance = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);

                    if (totalDistance < 1.5) {
                        hooverXP(entity);
                    } else if (shouldAttract(func_174877_v(), entity)) {
                        double d = 1 - (Math.max(0.1, totalDistance) / maxDist);
                        double speed = 0.01 + (d * 0.02);

                        entity.field_70159_w += xDist / totalDistance * speed;
                        entity.field_70179_y += zDist / totalDistance * speed;
                        entity.field_70181_x += yDist / totalDistance * speed;
                        if (yDist > 0.5) {
                            entity.field_70181_x = 0.12;
                        }

                        // force client sync because this movement is server-side only
                        boolean silent = entity.func_174814_R();
                        entity.func_174810_b(!silent);
                        entity.func_174810_b(silent);
                    }
                }
            } else {
                this.facing = getPoweredSide();
                ejectExperience(DirUtils.rotateFacingAroundY(this.facing, false));
            }

            if (facing != state.func_177229_b(DirUtils.TILTING)) {
                field_145850_b.func_175656_a(field_174879_c, state.func_177226_a(DirUtils.TILTING, facing));
            }
        }
    }

    private void ejectExperience(EnumFacing facing) {
        if(experience > 0) {
            BlockPos target = field_174879_c.func_177972_a(facing);
            IBlockState targetState = getBlockWorld().func_180495_p(target);
            boolean ejectIntoWorld = getBlockWorld().func_175623_d(target) || targetState.func_177230_c().func_176200_f(getBlockWorld(), target) || !targetState.func_185904_a().func_76220_a() || targetState.func_185900_c(getBlockWorld(), target).field_72337_e < 0.5d;
            if (ejectIntoWorld) {
                Vec3i vec = new BlockPos(0, 0, 0).func_177972_a(facing);
                int xp = EntityXPOrb.func_70527_a(experience);
                experience -= xp;
                func_70296_d();
                EntityXPOrb orb = new EntityXPOrb(field_145850_b, field_174879_c.func_177958_n() + 0.5F - (vec.func_177958_n() / 4d), field_174879_c.func_177956_o() + 0.25D, field_174879_c.func_177952_p() + 0.5D - (vec.func_177952_p() / 4d), xp);
                orb.field_70159_w = 0.0D;
                orb.field_70181_x = 0.0D;
                orb.field_70179_y = 0.0D;
                field_145850_b.func_72838_d(orb);
            }
        }
    }

    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    public static final String BWM_PULLER_TAG = "BWMpuller";

    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity) {

        if (entity == null || entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile && entity.field_70181_x > 0.01) {
            return false;
        }

        NBTTagCompound data = entity.getEntityData();

        if (isReservedByOthers(data)) {
            return false;
        }

        if (!isReservedByBWM(data)) {
            // if it is not being pulled already, pull it
            if (pullerPos != null) {
                data.func_74772_a(BWM_PULLER_TAG, pullerPos.func_177986_g());
            }
            return true;
        }

        if (pullerPos == null) {
            // it is already being pulled, so with no further info we are done
            return false;
        }

        long posL = data.func_74763_f(BWM_PULLER_TAG);
        if (posL == pullerPos.func_177986_g()) {
            // item already pulled from pullerPos so done
            return true;
        }

        // it is being pulled by something else, so check to see if we are closer
        BlockPos curOwner = BlockPos.func_177969_a(posL);
        double distToCur = curOwner.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double distToMe = pullerPos.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (distToMe + 1 < distToCur) {
            // only take over if it is clearly nearer to us
            data.func_74772_a(BWM_PULLER_TAG, pullerPos.func_177986_g());
            return true;
        }
        return false;
    }

    public static void release(@Nullable Entity entity) {
        if (entity != null && !entity.field_70128_L) {
            NBTTagCompound data = entity.getEntityData();
            data.func_82580_o(BWM_PULLER_TAG);
        }
    }

    public static boolean isReserved(Entity entity) {
        return isReservedByBWM(entity.getEntityData()) || isReservedByOthers(entity.getEntityData());
    }

    public static boolean isReservedByBWM(NBTTagCompound data) {
        return data.func_74764_b(BWM_PULLER_TAG);
    }


    public static boolean isReservedByOthers(NBTTagCompound data) {
        return data.func_74764_b(PREVENT_REMOTE_MOVEMENT);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.facing = tag.func_74764_b("facing") ? EnumFacing.func_82600_a(tag.func_74762_e("facing")) : EnumFacing.UP;
        this.experience = tag.func_74764_b("Experience") ? tag.func_74762_e("Experience") : 0;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("facing", facing.func_176745_a());
        t.func_74768_a("Experience", this.experience);
        return t;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        }
        return super.getCapability(capability, facing);
    }

    private boolean isInputtingPower(EnumFacing facing) {
        return this.getMechanicalInput(facing) > 0;
    }

    private EnumFacing getPoweredSide() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (isInputtingPower(facing))
                return facing;
        }
        return null;
    }

    private boolean isPowered() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (isInputtingPower(facing))
                return true;
        }
        return false;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return func_174877_v();
    }

    @Override
    public Block getBlock() {
        return func_145838_q();
    }
}
