package betterwithmods.common.blocks.tile;

import betterwithmods.common.fluid.FluidTankRestricted;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityBucket extends TileFluid implements ITickable {
    private int ticks;

    @Override
    public FluidTank createTank() {
        return new FluidTankRestricted(new FluidStack(FluidRegistry.WATER, 0), getCapacity());
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public int getCapacity() {
        return Fluid.BUCKET_VOLUME * 8;
    }

    @Override
    public boolean hasFluid(EnumFacing facing) {
        return true;
    }


    private boolean isWater(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i;
    }

    @Override
    public void func_73660_a() {
        if (!isFull() && ticks > 100) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                if (isWater(field_145850_b.func_180495_p(field_174879_c.func_177972_a(face)))) {
                    if (fill(new FluidStack(FluidRegistry.WATER, Fluid.BUCKET_VOLUME), true)) {
                        break;
                    }
                }
            }
            ticks = 0;
        }
        ticks++;
    }
}
