package betterwithmods.common.blocks.tile;

import betterwithmods.module.hardcore.beacons.CapabilityBeacon;
import betterwithmods.module.hardcore.beacons.HCBeacons;
import betterwithmods.module.hardcore.beacons.IBeaconEffect;
import betterwithmods.module.hardcore.beacons.SpawnBeaconEffect;
import betterwithmods.util.ColorUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import static betterwithmods.module.hardcore.beacons.HCBeacons.BEACON_EFFECTS;

/**
 * Created by primetoxinz on 7/17/17.
 */
public class TileEntityBeacon extends net.minecraft.tileentity.TileEntityBeacon implements ITickable {

    private int level, prevLevel;
    private IBlockState type = Blocks.field_150350_a.func_176223_P();
    private IBeaconEffect effect, prevEffect;
    private int tick;
    private List<BeamSegment> segments = Lists.newArrayList();

    @SideOnly(Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(Side.CLIENT)
    private float beamRenderScale;


    public TileEntityBeacon() {
        MinecraftForge.EVENT_BUS.register(this);
    }

    public boolean canSeeSky() {

        if (field_145850_b.field_73011_w.func_76569_d()) {
            return field_145850_b.func_175710_j(field_174879_c);
        } else if (field_145850_b.field_73011_w.func_177495_o()) {
            BlockPos.MutableBlockPos pos;
            for (pos = new BlockPos.MutableBlockPos(func_174877_v().func_177984_a()); pos.func_177956_o() < 128; pos.func_185336_p(pos.func_177956_o() + 1)) {
                IBlockState state = field_145850_b.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150357_h)
                    return true;
                if (state.func_177230_c().getLightOpacity(state, field_145850_b, pos) > 0)
                    return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        if (tick <= 0) {
            if (!canSeeSky()) {
                if (level != 0) {
                    this.level = 0;
                    this.prevLevel = 0;
                    field_145850_b.func_184133_a(null, field_174879_c, SoundEvents.field_187849_gA, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return;
            }
            Pair<Integer, IBlockState> current = calcLevel();
            level = current.getKey();
            type = current.getValue();
            if (level > 0) {
                effect = HCBeacons.getBeaconEffect(type);
                if (level != prevLevel) {
                    CapabilityBeacon storage = field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                    if (storage != null) {
                        storage.addBeacon(field_174879_c, level);
                    }
                    this.field_145850_b.func_175669_a(1023, func_174877_v(), 0);
                    if (effect != null)
                        effect.breakBlock(field_145850_b, field_174879_c, prevLevel);
                    //TRIGGER ADVANCEMENT
                    this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(field_174879_c, field_174879_c.func_177982_a(1, -4, 1)).func_72314_b(10.0D, 5.0D, 10.0D)).forEach(player -> CriteriaTriggers.field_192131_k.func_192180_a(player, this));
                }
                if (effect != null) {
                    effect.effect(field_145850_b, field_174879_c, level);
                    calcSegments();
                }
                prevEffect = effect;
            } else {
                this.segments.clear();
                this.effect = null;
                CapabilityBeacon storage = field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                if (storage != null) {
                    storage.removeBeacon(field_174879_c);
                }
            }
            if (prevEffect != null && effect != prevEffect) {
                prevEffect.breakBlock(field_145850_b, field_174879_c, prevLevel);
            }
            if (level != prevLevel) {

                prevLevel = level;
            }
            tick = effect != null ? effect.getTickSpeed() : 120;
        }
        tick--;
    }

    @SideOnly(Side.CLIENT)
    public float getBeamScale() {

        int i = (int) (this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();

        if (i > 1) {
            this.beamRenderScale -= (float) i / 40.0F;

            if (this.beamRenderScale < 0.0F) {
                this.beamRenderScale = 0.0F;
            }
        }

        this.beamRenderScale += 0.025F;

        if (this.beamRenderScale > 1.0F) {
            this.beamRenderScale = 1.0F;
        }

        return this.beamRenderScale;
    }

    private void calcSegments() {
        this.segments.clear();
        BeamSegment segment = new BeamSegment(ColorUtils.getColorFromBlock(field_145850_b, func_174877_v().func_177984_a(), func_174877_v()));
        this.segments.add(segment);
        BlockPos.MutableBlockPos pos;
        for (pos = new BlockPos.MutableBlockPos(func_174877_v().func_177984_a()); pos.func_177956_o() < 256; pos.func_189536_c(EnumFacing.UP)) {
            float[] color = ColorUtils.getColorFromBlock(field_145850_b, pos, func_174877_v());
            if (!Arrays.equals(color, new float[]{1, 1, 1})) {
                color = ColorUtils.average(color, segment.func_177263_b());
                if (Arrays.equals(color, segment.func_177263_b())) {
                    segment.func_177262_a();
                } else {
                    segment = new BeamSegment(color);
                    segments.add(segment);
                }
            } else {
                segment.func_177262_a();
            }
        }
    }

    public List<BeamSegment> getSegments() {
        return segments;
    }

    private boolean isSameBlock(IBlockState state, int x, int y, int z) {
        BlockPos pos = func_174877_v().func_177982_a(x, y, z);
        return state == field_145850_b.func_180495_p(pos);
    }


    private boolean isValidBlock(IBlockState state) {
        return BEACON_EFFECTS.containsKey(state) || state.func_177230_c().isBeaconBase(field_145850_b, field_174879_c.func_177977_b(), field_174879_c);
    }

    public Pair<Integer, IBlockState> calcLevel() {
        IBlockState state = field_145850_b.func_180495_p(field_174879_c.func_177977_b());
        if (isValidBlock(state)) {
            int r;
            for (r = 1; r <= 4; r++) {
                for (int x = -r; x <= r; x++) {
                    for (int z = -r; z <= r; z++) {
                        if (!isSameBlock(state, x, -r, z))
                            return Pair.of(r - 1, state);
                    }
                }
            }
            return Pair.of(r - 1, state);
        }
        return Pair.of(0, Blocks.field_150350_a.func_176223_P());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("level", level);
        compound.func_74768_a("prevLevel", prevLevel);
        compound.func_74768_a("tick", tick);
        NBTTagCompound tag = new NBTTagCompound();
        NBTUtil.func_190009_a(tag, type);
        compound.func_74782_a("type", tag);

        if (SpawnBeaconEffect.SPAWN_LIST.containsKey(this.func_174877_v())) {
            NBTTagList list = new NBTTagList();
            for (SpawnBeaconEffect.BindingPoint point : SpawnBeaconEffect.SPAWN_LIST.get(this.func_174877_v())) {
                list.func_74742_a(point.serializeNBT());
            }
            compound.func_74782_a("spawns", list);
        }

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        level = compound.func_74762_e("level");
        prevLevel = compound.func_74762_e("prevLevel");
        tick = compound.func_74762_e("tick");

        NBTTagCompound type = (NBTTagCompound) compound.func_74781_a("type");
        this.type = NBTUtil.func_190008_d(type);
        if (compound.func_74764_b("spawns")) {
            NBTTagList list = compound.func_150295_c("spawns", 10);
            HashSet<SpawnBeaconEffect.BindingPoint> points = Sets.newHashSet();
            for (Iterator<NBTBase> iter = list.iterator(); iter.hasNext(); ) {
                NBTTagCompound tag = (NBTTagCompound) iter.next();
                points.add(new SpawnBeaconEffect.BindingPoint(tag));
            }
            SpawnBeaconEffect.SPAWN_LIST.put(this.func_174877_v(), points);
        }
        super.func_145839_a(compound);
    }

    public boolean processInteraction(World world, EntityPlayer player, ItemStack stack) {
        if (player.func_184812_l_() && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock) stack.func_77973_b()).func_179223_d();
                IBlockState state = block.func_176203_a(stack.func_77960_j());
                if (isValidBlock(state)) {
                    int r;
                    for (r = 1; r <= stack.func_190916_E(); r++) {
                        for (int x = -r; x <= r; x++) {
                            for (int z = -r; z <= r; z++) {
                                this.field_145850_b.func_175656_a(func_174877_v().func_177982_a(x, -r, z), state);
                            }
                        }
                    }
                }
            }
        }

        if (!world.field_72995_K) {
            if (this.effect != null) {
                boolean interacted = this.effect.processInteractions(world, func_174877_v(), func_191979_s() - 1, player, stack);
                if (interacted)
                    this.field_145850_b.func_175669_a(1023, func_174877_v(), 0);
                return interacted;
            }
        }
        return false;
    }

    @Override
    public int func_191979_s() {
        return level;
    }

    public boolean isEnabled() {
        return level > 0;
    }


    public void onRemoved() {
        breakBlock();
        MinecraftForge.EVENT_BUS.unregister(this);
        SpawnBeaconEffect.removeAll(func_174877_v());
        CapabilityBeacon storage = field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
        if (storage != null) {
            storage.removeBeacon(field_174879_c);
        }
    }

    @SubscribeEvent
    public void findSpawn(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) return;
        EntityPlayerMP player = (EntityPlayerMP) event.getEntity();
        if (SpawnBeaconEffect.shouldSpawnHere(this.func_174877_v(), player, field_145850_b)) {
            player.func_180473_a(this.func_174877_v().func_177984_a(), true);
        } else {
            player.func_180473_a(field_145850_b.func_175694_M(), false);
        }
    }


    public class BeamSegment extends net.minecraft.tileentity.TileEntityBeacon.BeamSegment {
        public BeamSegment(float[] colorsIn) {
            super(colorsIn);
        }

        @Override
        protected void func_177262_a() {
            super.func_177262_a();
        }
    }

    public void breakBlock() {
        if (effect != null) {
            this.effect.breakBlock(field_145850_b, field_174879_c, level);
        }
    }
}
