package betterwithmods.common.blocks.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

import javax.annotation.Nonnull;
import java.util.function.BiFunction;

import static betterwithmods.module.hardcore.beacons.EnderchestCap.ENDERCHEST_CAPABILITY;

public class TileEnderchest extends TileEntityEnderChest {

    public enum Type {
        NONE((tile, player) -> tile.getCapability(ENDERCHEST_CAPABILITY, EnumFacing.UP).getInventory()),
        DIMENSION1((tile, player) -> {
            World world = tile.func_145831_w();
            if (world.hasCapability(ENDERCHEST_CAPABILITY, EnumFacing.SOUTH)) {
                return world.getCapability(ENDERCHEST_CAPABILITY, EnumFacing.SOUTH).getInventory();
            }
            return null;
        }),
        DIMENSION2((tile, player) -> tile.func_145831_w().getCapability(ENDERCHEST_CAPABILITY, EnumFacing.NORTH).getInventory()),
        GLOBAL((tile, player) -> DimensionManager.getWorld(0).getCapability(ENDERCHEST_CAPABILITY, EnumFacing.DOWN).getInventory()),
        PRIVATE((tile, player) -> player.func_71005_bN());

        public static Type[] VALUES = values();

        private BiFunction<TileEntity, EntityPlayer, InventoryEnderChest> function;

        Type(BiFunction<TileEntity, EntityPlayer, InventoryEnderChest> function) {
            this.function = function;
        }

        public BiFunction<TileEntity, EntityPlayer, InventoryEnderChest> getFunction() {
            return function;
        }
    }

    private Type type = Type.NONE;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("type", type.ordinal());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("type"))
            this.type = Type.VALUES[compound.func_74762_e("type")];
        super.func_145839_a(compound);
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Nonnull
    public Type getType() {
        return type;
    }



}

