package betterwithmods.common.blocks.tile;

import betterwithmods.util.InvUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

import java.util.function.Predicate;

/**
 * Created by primetoxinz on 9/4/16.
 */
public abstract class TileBasicInventory extends TileBasic {

    public Predicate<EnumFacing> hasCapability = facing -> true;
    public SimpleStackHandler inventory = createItemStackHandler();

    public abstract int getInventorySize();

    public SimpleStackHandler createItemStackHandler() {
        return new SimpleStackHandler(getInventorySize(), this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if(capability == net.minecraftforge.items.CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || hasCapability.test(facing)))
            return true;
        return  super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (hasCapability(capability,facing) && capability == net.minecraftforge.items.CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
            return net.minecraftforge.items.CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast(inventory);
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_179237_a(inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (inventory == null)
            inventory = createItemStackHandler();
        inventory.deserializeNBT(compound);
        super.func_145839_a(compound);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onBreak() {
        IItemHandler inv = getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        if (inv != null)
            InvUtils.ejectInventoryContents(field_145850_b, field_174879_c, inv);
    }

}
