package betterwithmods.common.blocks.mini;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

import betterwithmods.common.blocks.mini.BlockMini.PropertyOrientation;

public class BlockSiding extends BlockMini {
    public BlockSiding(Material mat) {
        super(mat);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, 0).func_177226_a(getOrientationProperty(), 0));
    }

    @Override
    public PropertyOrientation getOrientationProperty() {
        return SIDING_ORIENTATION;
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        PropertyInteger facingProperty = getOrientationProperty();
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5F;
        float hitYFromCenter = hitY - 0.5F;
        float hitZFromCenter = hitZ - 0.5F;
        switch (facing.func_176740_k()) {
            case Y:
                if (inCenter(hitXFromCenter, hitZFromCenter, 0.25f)) {
                    state = state.func_177226_a(facingProperty, facing.func_176734_d().func_176745_a());
                } else if (isMax(hitXFromCenter, hitZFromCenter)) {
                    state = state.func_177226_a(facingProperty, ((hitXFromCenter > 0) ? EnumFacing.EAST : EnumFacing.WEST).func_176745_a());
                } else {
                    state = state.func_177226_a(facingProperty, ((hitZFromCenter > 0) ? EnumFacing.SOUTH : EnumFacing.NORTH).func_176745_a());
                }
                break;
            case X:
                if (inCenter(hitYFromCenter, hitZFromCenter, 0.25f)) {
                    state = state.func_177226_a(facingProperty, facing.func_176734_d().func_176745_a());
                } else if (isMax(hitYFromCenter, hitZFromCenter)) {
                    state = state.func_177226_a(facingProperty, ((hitYFromCenter > 0) ? EnumFacing.UP : EnumFacing.DOWN).func_176745_a());
                } else {
                    state = state.func_177226_a(facingProperty, ((hitZFromCenter > 0) ? EnumFacing.SOUTH : EnumFacing.NORTH).func_176745_a());
                }
                break;
            case Z:
                if (inCenter(hitYFromCenter, hitXFromCenter, 0.25f)) {
                    state = state.func_177226_a(facingProperty, facing.func_176734_d().func_176745_a());
                } else if (isMax(hitYFromCenter, hitXFromCenter)) {
                    state = state.func_177226_a(facingProperty, ((hitYFromCenter > 0) ? EnumFacing.UP : EnumFacing.DOWN).func_176745_a());
                } else {
                    state = state.func_177226_a(facingProperty, ((hitXFromCenter > 0) ? EnumFacing.EAST : EnumFacing.WEST).func_176745_a());
                }
                break;
            default:
                state = state.func_177226_a(facingProperty, facing.func_176734_d().func_176745_a());
                break;
        }

        return state;
    }

    private static final AxisAlignedBB[] boxes = new AxisAlignedBB[]{
            new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 0.5D, 1.0D),
            new AxisAlignedBB(0.0D, 0.5D, 0.0D, 1.0D, 1.0D, 1.0D),
            new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 1.0D, 0.5D),
            new AxisAlignedBB(0.0D, 0.0D, 0.5D, 1.0D, 1.0D, 1.0D),
            new AxisAlignedBB(0.0D, 0.0D, 0.0D, 0.5D, 1.0D, 1.0D),
            new AxisAlignedBB(0.5D, 0.0D, 0.0D, 1.0D, 1.0D, 1.0D),
    };

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = func_176221_a(state, source, pos).func_177229_b(getOrientationProperty());
        return boxes[i];
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        EnumFacing facing = EnumFacing.func_82600_a(state.func_177229_b(getOrientationProperty()));
        return facing == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}
