package betterwithmods.common.blocks.mini;

import betterwithmods.api.block.IAdvancedRotationPlacement;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

import betterwithmods.api.block.IRenderRotationPlacement.RenderFunction;

@Deprecated
public abstract class BlockMini extends BlockRotate implements IMultiVariants, IAdvancedRotationPlacement, IDamageDropped, IRenderRotationPlacement {
    public static final Material MINI = new Material(MapColor.field_151663_o);
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a("type", 0, 15);
    public static final PropertyOrientation SIDING_ORIENTATION = PropertyOrientation.create("orientation", 0, 5);
    public static final PropertyOrientation MOULDING_ORIENTATION = PropertyOrientation.create("orientation", 0, 11);
    public static final PropertyOrientation CORNER_ORIENTATION = PropertyOrientation.create("orientation", 0, 7);

    public BlockMini(Material material) {
        super(material);
    }

    public abstract PropertyOrientation getOrientationProperty();

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177231_a(getOrientationProperty()));
    }

    @Override
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        Material mat = func_149688_o(blockState);
        if (mat == Material.field_151575_d || mat == MINI)
            return 2.0F;
        return 3.0F;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        Material mat = func_149688_o(state);
        if (mat == Material.field_151575_d || mat == MINI)
            return SoundType.field_185848_a;
        return SoundType.field_185851_d;
    }

    @Override
    public boolean isToolEffective(String type, IBlockState state) {
        return type != null && type.equals(getHarvestTool(state));
    }

    @Nullable
    @Override
    public String getHarvestTool(IBlockState state) {
        Material mat = func_149688_o(state);
        if (mat == Material.field_151575_d || mat == MINI)
            return "axe";
        return "pickaxe";
    }

    @Override
    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    public int getUsedTypes() {
        return 6;
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = Lists.newArrayList();
        for (int i = 0; i < getUsedTypes(); i++) {
            variants.add(String.format("orientation=3,type=%s", i));
        }
        return variants.toArray(new String[variants.size()]);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P();
    }


    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(TYPE);
    }

    @Override
    public int damageDropped(IBlockState state, World world, BlockPos pos) {
        TileEntityMultiType tile = getTile(world, pos);
        if (tile != null) {
            return tile.getType();
        }
        return 0;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityMultiType tile = getTile(world, pos);
        if (tile != null) {
            tile.setOrientation((tile.getOrientation() + 1) % (getOrientationProperty().getMax() + 1));
            IBlockState state = world.func_180495_p(pos);
            world.func_175656_a(pos, func_176221_a(state, world, pos));
            return true;
        }
        return false;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean emptyHands = player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && player.func_70093_af();
        if (emptyHands) {
            if (rotateBlock(world, pos, facing)) {
                world.func_184133_a(null, pos, this.getSoundType(state, world, pos, player).func_185841_e(), SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.1F + 0.9F);
                world.func_175685_c(pos, this, false);
                world.func_180497_b(pos, this, 10, 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return getStateForAdvancedRotationPlacement(func_176223_P(), facing, hitX, hitY, hitZ);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityMultiType tile = getTile(worldIn, pos);
        if (tile != null) {
            tile.setType(stack.func_77960_j());
            tile.setOrientation(state.func_177229_b(getOrientationProperty()));
        }
    }

    @Override
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntityMultiType tile = getTile(world, pos);
        if (tile != null) {
            return new ItemStack(this, 1, tile.getType());
        }
        return new ItemStack(this, 1, 0);
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
//        for (int i = 0; i < getUsedTypes(); i++) {
//            items.add(new ItemStack(this, 1, i));
//        }
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_184812_l_())
            InvUtils.ejectStackWithOffset(worldIn, pos, getDrops(worldIn, pos, state, 0));
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this, 1, func_176221_a(state, world, pos).func_177229_b(TYPE));
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityMultiType tile = getTile(world, pos);
        if (tile != null) {
            return Lists.newArrayList(new ItemStack(this, 1, tile.getType()));
        }
        return Lists.newArrayList();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMultiType();
    }


    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityMultiType tile = getTile(worldIn, pos);
        if (tile != null) {
            int o = tile.getOrientation() % (getOrientationProperty().getMax() + 1);
            return state.func_177226_a(TYPE, tile.getType()).func_177226_a(getOrientationProperty(), o);
        }
        return state;
    }


    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, TYPE, getOrientationProperty());
    }

    @Override
    public IBlockState getRenderState(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return func_180642_a(world, pos, facing, flX, flY, flZ, stack.func_77960_j(), placer).func_177226_a(TYPE, stack.func_77960_j());
    }

    @Override
    public RenderFunction getRenderFunction() {
        return ClientEventHandler::renderMiniBlock;
    }

    public TileEntityMultiType getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMultiType)
            return (TileEntityMultiType) tile;
        return null;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("This item is deprecated. It is replaced with a new version to allow more texture variants. It has a recipe to convert directly to the new version.");
    }

    public enum EnumType {

        STONE(0, "stone", Blocks.field_150348_b),
        STONEBRICK(1, "stone_brick", Blocks.field_150417_aV),
        WHITESTONE(2, "whitestone", new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.WHITESTONE.getMeta())),
        NETHERBRICK(3, "nether_brick", Blocks.field_150385_bj),
        BRICK(4, "brick", Blocks.field_150336_V),
        SANDSTONE(5, "sandstone", Blocks.field_150322_A);

        public static final BlockMini.EnumType[] VALUES = values();

        private final int meta;
        private final String name;
        private final ItemStack block;
        private final IBlockState state;

        EnumType(int metaIn, String nameIn, Block blockIn) {
            this(metaIn, nameIn, new ItemStack(blockIn));
        }

        EnumType(int metaIn, String nameIn, ItemStack blockIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.block = blockIn;
            this.state = BWMRecipes.getStateFromStack(blockIn);
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getName() {
            return this.name;
        }

        public ItemStack getBlock() {
            return this.block;
        }

        public IBlockState getState() {
            return this.state;
        }
    }

    public static class PropertyOrientation extends PropertyInteger {
        private int min, max;

        private PropertyOrientation(String name, int min, int max) {
            super(name, min, max);
            this.min = min;
            this.max = max;
        }

        public static PropertyOrientation create(String name, int min, int max) {
            return new PropertyOrientation(name, min, max);
        }

        public int getMin() {
            return min;
        }

        public int getMax() {
            return max;
        }
    }
}
