package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.util.DirUtils;
import betterwithmods.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import java.util.List;
import java.util.Random;
import java.util.Set;

public class TileSteelSaw extends TileAxleMachine {
    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }

    public static final AxisAlignedBB X_BOX = new AxisAlignedBB(0, -1, -1, 0, 1, 1);
    public static final AxisAlignedBB Y_BOX = new AxisAlignedBB(-1, 0, -1, 1, 0, 1);
    public static final AxisAlignedBB Z_BOX = new AxisAlignedBB(-1, -1, 0, 1, 1, 0);
    public static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{X_BOX, Y_BOX, Z_BOX};

    @Override
    public int getPower() {
        if (!isValid())
            return 0;
        return super.getPower();
    }

    public boolean isValid() {
        IBlockState state = field_145850_b.func_180495_p(field_174879_c);
        boolean valid = true;
        Set<BlockPos> positions = WorldUtils.getPosAround(field_174879_c, state.func_177229_b(DirUtils.AXIS));
        for (BlockPos check : positions) {
            if (check.equals(func_174877_v()))
                continue;
            if (!saw(field_145850_b, check, field_145850_b.field_73012_v, true)) {
                valid = false;
                break;
            }
        }
        return valid;
    }

    @Override
    public void func_73660_a() {
        IBlockState state = field_145850_b.func_180495_p(field_174879_c);
        Set<BlockPos> positions = WorldUtils.getPosAround(field_174879_c, state.func_177229_b(DirUtils.AXIS));
        if (getPower() > 0 && field_145850_b.func_82737_E() % 10 == 0) {
            EnumFacing.Axis axis = state.func_177229_b(DirUtils.AXIS);
            AxisAlignedBB box = BOXES[axis.ordinal()].func_186670_a(field_174879_c);
            List<EntityLivingBase> entities = field_145850_b.func_72872_a(EntityLivingBase.class, box.func_186662_g(.25));
            if (!entities.isEmpty()) {
                entities.forEach(this::hitEntity);
                field_145850_b.func_184133_a(null, field_174879_c, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0F + field_145850_b.field_73012_v.nextFloat() * 0.1F, 1.5F + field_145850_b.field_73012_v.nextFloat() * 0.1F);
            }
            List<EntityItem> items = field_145850_b.func_72872_a(EntityItem.class, box.func_186662_g(0.5));
            if (!items.isEmpty()) {
                items.forEach(item -> moveItems(axis, item));
                field_145850_b.func_184133_a(null, field_174879_c, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0F + field_145850_b.field_73012_v.nextFloat() * 0.1F, 1.5F + field_145850_b.field_73012_v.nextFloat() * 0.1F);
            }

            for (BlockPos pos : positions) {
                if (!pos.equals(func_174877_v()))

                    saw(field_145850_b, pos, field_145850_b.field_73012_v, false);
            }

        }
    }

    private void moveItems(EnumFacing.Axis axis, EntityItem item) {
        BlockPos itemPos = item.func_180425_c();
        int x = func_174877_v().func_177958_n() - itemPos.func_177958_n();
        int y = func_174877_v().func_177956_o() - itemPos.func_177956_o();
        int z = func_174877_v().func_177952_p() - itemPos.func_177952_p();
        switch (axis) {
            default:
                break;
            case X:
                if (z == 0)
                    item.func_70016_h(0, 0, y / 2d);
                break;
            case Z:
                if (x == 0)
                    item.func_70016_h(y / 2d, 0, 0);
                break;
        }


    }

    private void hitEntity(EntityLivingBase entity) {
        entity.field_70718_bc = 60;
        if (field_145850_b instanceof WorldServer) {
            if (BWDamageSource.getSawDamage() != null)
                entity.func_70097_a(BWDamageSource.getSteelSawDamage(), 10);
        }
    }

    @Override
    public byte getMaximumSignal() {
        return 5;
    }

    private boolean saw(World world, BlockPos pos, Random rand, boolean simulate) {
//        IBlockState state = world.getBlockState(pos);

//        if (world.isRemote || !(world instanceof WorldServer))
//            return true;
//        if (world.isAirBlock(pos))
//            return true;
//        Block block = state.getBlock();
//        int harvestMeta = block.damageDropped(state);
//        if (block instanceof IDamageDropped)
//            harvestMeta = ((IDamageDropped) block).damageDropped(state, world, pos);
        //TODO
//        if (SawManager.WOOD_SAW.contains(block, harvestMeta)) {
//            if (!simulate) {
//                List<ItemStack> products = SawManager.WOOD_SAW.getProducts(block, harvestMeta);
//                world.setBlockToAir(pos);
//                if (!products.isEmpty())
//                    InvUtils.spawnStack(world, pos, products);
//                world.playSound(null, pos, SoundEvents.ENTITY_MINECART_RIDING, SoundCategory.BLOCKS, 1.5F + rand.nextFloat() * 0.1F, 2.0F + rand.nextFloat() * 0.1F);
//            }
//            return true;
//        } else if (SawManager.STEEL_SAW.contains(block, harvestMeta)) {
//
//            if (!simulate) {
//                List<ItemStack> products = SawManager.STEEL_SAW.getProducts(block, harvestMeta);
//                world.setBlockToAir(pos);
//                if (!products.isEmpty())
//                    InvUtils.spawnStack(world, pos, products);
//                world.playSound(null, pos, SoundEvents.ENTITY_MINECART_RIDING, SoundCategory.BLOCKS, 1.5F + rand.nextFloat() * 0.1F, 2.0F + rand.nextFloat() * 0.1F);
//            }
//            return true;
//        }
        return false;
    }

    @Override
    public World getBlockWorld() {
        return super.getBlockWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getBlockPos();
    }
}
