package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import com.google.common.collect.Lists;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

import java.util.List;

public class TileMerger extends TileGearbox {
    public TileMerger(int maxPower) {
        super(maxPower);
    }
    private List<Integer> leftHistory = Lists.newArrayList(0, 0, 0, 0, 0), rightHistory = Lists.newArrayList(0, 0, 0, 0, 0);

    @Override
    public void onChanged() {
        if (this.getBlockWorld().func_82737_E() % 20L != 0L)
            return;

        if (BWMAPI.IMPLEMENTATION.isRedstonePowered(field_145850_b, field_174879_c)) {
            setPower(0);
            func_70296_d();
            return;
        }
        int left = this.getMechanicalInput(getFacing());
        int right = this.getMechanicalInput(getFacing().func_176734_d());

//        if (leftHistory.size() >= 5)
//            leftHistory.remove(0);
//        leftHistory.add(left);
//        if (rightHistory.size() >= 5)
//            rightHistory.remove(0);
//        rightHistory.add(right);
//
//        int leftAverage = (int) Math.floor(leftHistory.stream().mapToDouble(i -> i).average().orElse(0));
//        int rightAverage = (int) Math.floor(rightHistory.stream().mapToDouble(i -> i).average().orElse(0));
        if(left < 1 ||  right < 1)
            return;
        if(left != right)
            getBlock().overpower(field_145850_b,field_174879_c);
        else {
            int power = (int) (3* left);
            if (power != this.power) {
                setPower(power);
            }
            func_70296_d();
        }

    }


    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing != getFacing() && facing != getFacing().func_176734_d() && BWMAPI.IMPLEMENTATION.isAxle(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d()))
            return Math.min(power, maxPower);
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        BlockPos pos = getBlockPos().func_177972_a(facing);
        if (BWMAPI.IMPLEMENTATION.getMechanicalPower(field_145850_b, pos, facing.func_176734_d()) != null && !(BWMAPI.IMPLEMENTATION.getMechanicalPower(field_145850_b, pos, facing.func_176734_d()) instanceof TileGearbox))
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, pos, facing.func_176734_d());
        return 0;
    }

}
