package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.BlockGearbox;
import betterwithmods.common.blocks.tile.TileBasic;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nonnull;

public class TileGearbox extends TileBasic implements IMechanicalPower {
    protected int power;
    protected int maxPower;
    protected int tick;
    protected int unchanged;

    public TileGearbox() {
    }

    public TileGearbox(int maxPower) {
        this.maxPower = maxPower;
    }

    public void onChanged() {
        tick++;
        if (tick < 20)
            return;
        tick = 0;

        if (BWMAPI.IMPLEMENTATION.isRedstonePowered(field_145850_b, field_174879_c)) {
            setPower(0);
            func_70296_d();
            return;
        }
        int power = this.getMechanicalInput(getFacing());


        if (power != this.power) {
            setPower(power);
            unchanged = 0;
        } else {
            unchanged++;
        }
        if (isOverpowered() && unchanged > 30) {
            getBlock().overpower(field_145850_b, field_174879_c);
        }
        func_70296_d();
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER
                || super.hasCapability(capability, facing);
    }

    @Nonnull
    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        return super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing != getFacing() && BWMAPI.IMPLEMENTATION.isAxle(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d()))
            return Math.min(power, maxPower);
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        BlockPos pos = getBlockPos().func_177972_a(facing);
        if (BWMAPI.IMPLEMENTATION.getMechanicalPower(field_145850_b, pos, facing.func_176734_d()) != null && !(BWMAPI.IMPLEMENTATION.getMechanicalPower(field_145850_b, pos, facing.func_176734_d()) instanceof TileGearbox))
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, pos, facing.func_176734_d());
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return this.maxPower;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        power = tag.func_74762_e("power");
        maxPower = tag.func_74762_e("maxPower");
    }

    @Nonnull
    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        tag.func_74768_a("power", power);
        tag.func_74768_a("maxPower", maxPower);
        return t;
    }


    public BlockGearbox getBlock() {
        return (BlockGearbox) func_145838_q();
    }

    public EnumFacing getFacing() {
        return getBlock().getFacing(field_145850_b, field_174879_c);
    }

    public int getPower() {
        return power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        getBlock().setActive(field_145850_b, field_174879_c, power > 0);
    }

    @Override
    public String toString() {
        return String.format("%s", power);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isOverpowered() {
        return this.power > getMaximumInput(getFacing());
    }
}
