package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockAxle;
import betterwithmods.common.blocks.mechanical.BlockWindmill;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillVertical extends TileEntityBaseWindmill {

    public TileEntityWindmillVertical() {
        this.bladeMeta = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    public boolean isSlaveValid(int offset) {
        int airCounter = 0;


        for (int x = -getRadius(); x <= getRadius(); x++) {
            for (int z = -getRadius(); z <= getRadius(); z++) {
                BlockPos offPos = field_174879_c.func_177982_a(x, offset, z);

                double s = Math.sqrt((x * x) + (z * z));
                if (s > 4.5) {
                    continue;
                }
                if (x == 0 && z == 0) {
                    IBlockState state = getBlockWorld().func_180495_p(offPos);
                    if (!(state.func_177230_c() instanceof BlockAxle))
                        return false;
                    continue;
                }
                if (getBlockWorld().func_175623_d(offPos)) {
                    airCounter++;
                } else {
                    return false;
                }

            }
        }
        return airCounter > 25;
    }

    @Override
    public void verifyIntegrity() {
        boolean valid = false;
        if (getBlockWorld().func_180495_p(field_174879_c).func_177230_c() == BWMBlocks.WINDMILL) {
            for (int i = -3; i <= 3; i++) {
                if (i != 0) {
                    if (isSlaveValid(i)) {
                        valid = true;
                    } else {
                        valid = false;
                        break;
                    }
                }
            }
        }

        isValid = valid && !isEnd();
    }

    @Override
    public int getRadius() {
        return 4;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = getBlockWorld().func_180495_p(this.field_174879_c);
        this.getBlockWorld().func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = getBlockWorld().func_180495_p(field_174879_c);
        if (state.func_177230_c() instanceof BlockWindmill)
            return new AxisAlignedBB(field_174879_c).func_72314_b(4, 3, 4);
        else
            return super.getRenderBoundingBox();
    }

}
