package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockWindmill;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillHorizontal extends TileEntityBaseWindmill {

    public TileEntityWindmillHorizontal() {
        super();
        this.bladeMeta = new int[]{0, 0, 0, 0};
    }

    @Override
    public void verifyIntegrity() {
        boolean valid = true;
        if (getBlockWorld().func_180495_p(field_174879_c).func_177230_c() == BWMBlocks.WINDMILL) {
            EnumFacing.Axis axis = getBlockWorld().func_180495_p(field_174879_c).func_177229_b(DirUtils.AXIS);
            for (int vert = -6; vert <= 6; vert++) {
                for (int i = -6; i <= 6; i++) {
                    int xP = (axis == EnumFacing.Axis.Z ? i : 0);
                    int zP = (axis == EnumFacing.Axis.X ? i : 0);
                    BlockPos offset = field_174879_c.func_177982_a(xP, vert, zP);
                    if (xP == 0 && vert == 0 && zP == 0)
                        continue;
                    else
                        valid = getBlockWorld().func_175623_d(offset);
                    if (!valid)
                        break;
                }
                if (!valid)
                    break;
            }
        }
        isValid = valid && this.getBlockWorld().func_175710_j(field_174879_c) && !isNether() && !isEnd();
    }

    @Override
    public int getRadius() {
        return 7;
    }

    //Extend the bounding box if the TESR is bigger than the occupying block.
    @Override
    @SideOnly(Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = getBlockWorld().func_180495_p(field_174879_c);
        if (!(state.func_177230_c() instanceof BlockWindmill))
            return Block.field_185505_j;

        EnumFacing.Axis axis = getBlockWorld().func_180495_p(field_174879_c).func_177229_b(DirUtils.AXIS);
        EnumFacing facing = (axis == EnumFacing.Axis.Z) ? EnumFacing.SOUTH : EnumFacing.EAST;
        Vec3i vec = facing.func_176730_m();
        int xP = axis == EnumFacing.Axis.Z ? getRadius() : 0;
        int yP = getRadius();
        int zP = axis == EnumFacing.Axis.X ? getRadius() : 0;
        return new AxisAlignedBB(-xP, -yP, -zP, xP, yP, zP).func_72317_d(0.5, 0.5, 0).func_186670_a(field_174879_c).func_72321_a(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }
}
