package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.block.IWaterCurrent;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockWaterwheel;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.HashMap;

public class TileEntityWaterwheel extends TileAxleGenerator {
    static HashMap<Block, IWaterCurrent> WATER_BLOCKS = new HashMap<>();

    public TileEntityWaterwheel() {
        super();
    }

    public static void registerWater(Block block) {
        if (block instanceof BlockLiquid)
            registerWater(block, IWaterCurrent.VANILLA_LIQUID);
        else if (block instanceof BlockFluidBase)
            registerWater(block, IWaterCurrent.FORGE_LIQUID);
        else
            registerWater(block, IWaterCurrent.NO_FLOW);
    }

    public static void registerWater(Block block, IWaterCurrent handler) {
        WATER_BLOCKS.put(block, handler);
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public boolean isWater(BlockPos pos) {
        IBlockState state = field_145850_b.func_180495_p(pos);
        return isVanillaWater(state) || isForgeFluid(state.func_177230_c()) || WATER_BLOCKS.containsKey(state.func_177230_c());
    }


    public IWaterCurrent getCurrentHandler(IBlockState state) {
        if (isVanillaWater(state))
            return IWaterCurrent.VANILLA_LIQUID;
        if (isForgeFluid(state.func_177230_c()))
            return IWaterCurrent.FORGE_LIQUID;
        return WATER_BLOCKS.get(state.func_177230_c());
    }

    private boolean isVanillaWater(IBlockState state) {
        return state.func_177230_c() instanceof BlockLiquid && state.func_185904_a() == Material.field_151586_h;
    }

    private boolean isForgeFluid(Block block) {
        return block instanceof BlockFluidBase && ((BlockFluidBase) block).getFluid() == FluidRegistry.WATER;
    }

    @Override
    public void verifyIntegrity() {
        boolean isAir = true;
        boolean hasWater = true;
        if (getBlockWorld().func_180495_p(field_174879_c).func_177230_c() == BWMBlocks.WATERWHEEL) {
            EnumFacing.Axis axis = getBlockWorld().func_180495_p(field_174879_c).func_177229_b(DirUtils.AXIS);
            for (int i = -2; i <= 2; i++) {
                for (int j = -2; j <= 2; j++) {
                    int xPos = (axis == EnumFacing.Axis.Z ? i : 0);
                    int zPos = (axis == EnumFacing.Axis.X ? i : 0);
                    BlockPos offset = field_174879_c.func_177982_a(xPos, j, zPos);
                    if (j == -2)
                        hasWater = isWater(offset);
                    if (!hasWater) {
                        hasWater = sidesHaveWater();
                        if (!hasWater)
                            break;
                    }
                    if (i == 0 && j == 0)
                        continue;
                    else if (j > -2) {
                        if (i == -2 || i == 2) {
                            isAir = getBlockWorld().func_175623_d(offset) || isWater(offset);
                        } else
                            isAir = getBlockWorld().func_175623_d(offset);
                    }
                    if (!isAir)
                        break;
                }
                if (!isAir || !hasWater)
                    break;
            }
        }
        isValid = isAir && hasWater;
    }

    public boolean sidesHaveWater() {
        EnumFacing.Axis axis = getBlockWorld().func_180495_p(field_174879_c).func_177229_b(DirUtils.AXIS);
        int leftWater = 0;
        int rightWater = 0;
        boolean bottomIsUnobstructed = true;
        for (int i = -2; i <= 2; i++) {
            int xLeft = axis == EnumFacing.Axis.Z ? -2 : 0;
            int xRight = axis == EnumFacing.Axis.Z ? 2 : 0;
            int zLeft = axis == EnumFacing.Axis.X ? -2 : 0;
            int zRight = axis == EnumFacing.Axis.X ? 2 : 0;
            BlockPos leftPos = field_174879_c.func_177982_a(xLeft, i, zLeft);
            BlockPos rightPos = field_174879_c.func_177982_a(xRight, i, zRight);
            if (isWater(leftPos))
                leftWater++;
            else if (isWater(rightPos))
                rightWater++;

            int xP = axis == EnumFacing.Axis.Z ? i : 0;
            int yP = -2;
            int zP = axis == EnumFacing.Axis.X ? i : 0;
            BlockPos bPos = field_174879_c.func_177982_a(xP, yP, zP);
            bottomIsUnobstructed = getBlockWorld().func_175623_d(bPos) || isWater(bPos);
            if (!bottomIsUnobstructed)
                break;
        }
        return bottomIsUnobstructed && (leftWater != 0 || rightWater != 0) && (leftWater < rightWater || leftWater > rightWater);
    }

    @Override
    public void calculatePower() {
        byte power = 0;
        if (isValid()) {
            Vec3d overallFlow = Vec3d.field_186680_a;
            EnumFacing.Axis axis = getBlockWorld().func_180495_p(field_174879_c).func_177229_b(DirUtils.AXIS);
            int leftWater = 0;
            int rightWater = 0;
            for (int i = 0; i < 3; i++) {
                int metaPos = i - 1;
                int xP = axis == EnumFacing.Axis.Z ? metaPos : 0;
                int zP = axis == EnumFacing.Axis.X ? metaPos : 0;
                BlockPos lowPos = field_174879_c.func_177982_a(xP, -2, zP);
                IBlockState lowState = getBlockWorld().func_180495_p(lowPos);
                IWaterCurrent current = getCurrentHandler(lowState);
                if (current != null)
                    overallFlow = overallFlow.func_178787_e(current.getFlowDirection(getBlockWorld(), lowPos, lowState));
            }
            for (int i = -1; i < 3; i++) {
                int xLeft = axis == EnumFacing.Axis.Z ? -2 : 0;
                int xRight = axis == EnumFacing.Axis.Z ? 2 : 0;
                int zLeft = axis == EnumFacing.Axis.X ? -2 : 0;
                int zRight = axis == EnumFacing.Axis.X ? 2 : 0;
                BlockPos leftPos = field_174879_c.func_177982_a(xLeft, i, zLeft);
                BlockPos rightPos = field_174879_c.func_177982_a(xRight, i, zRight);
                if (isWater(leftPos))
                    leftWater++;
                if (isWater(rightPos))
                    rightWater++;
            }
            int xFlow = Math.abs(overallFlow.field_72450_a) > 2 ? (int) Math.signum(overallFlow.field_72450_a) : 0;
            int zFlow = Math.abs(overallFlow.field_72449_c) > 2 ? (int) Math.signum(overallFlow.field_72449_c) : 0;
            int relevantFlow = 0;
            if (axis == EnumFacing.Axis.X)
                relevantFlow = zFlow;
            if (axis == EnumFacing.Axis.Z)
                relevantFlow = xFlow;
            if (leftWater > rightWater || (relevantFlow > 0 && leftWater >= rightWater))
                waterMod = -1;
            else if (rightWater > leftWater || (relevantFlow < 0 && rightWater >= leftWater))
                waterMod = 1;
            else {
                waterMod = 0;
            }
            if (waterMod != 0) {
                power = 1;
            }
        }
        if (power != this.power) {
            setPower(power);
        }
    }


    //Extend the bounding box if the TESR is bigger than the occupying block.
    @Override
    @SideOnly(Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = getBlockWorld().func_180495_p(field_174879_c);
        if (!(state.func_177230_c() instanceof BlockWaterwheel))
            return Block.field_185505_j;

        EnumFacing.Axis axis = state.func_177229_b(DirUtils.AXIS);
        EnumFacing facing = (axis == EnumFacing.Axis.Z) ? EnumFacing.SOUTH : EnumFacing.EAST;
        Vec3i vec = facing.func_176730_m();
        int xP = axis == EnumFacing.Axis.Z ? getRadius() : 0;
        int yP = getRadius();
        int zP = axis == EnumFacing.Axis.X ? getRadius() : 0;

        return new AxisAlignedBB(-xP, -yP, -zP, xP, yP, zP).func_72317_d(0.5, 0.5, 0.5).func_186670_a(field_174879_c).func_72321_a(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    @Override
    public Block getBlock() {
        return func_145838_q();
    }

    @Override
    public int getRadius() {
        return 2;
    }
}
