package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.tile.IMechSubtype;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.common.registry.TurntableRotationManager;
import betterwithmods.common.registry.block.recipe.TurntableRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nonnull;

public class TileEntityTurntable extends TileBasic implements IMechSubtype, ITickable, IMechanicalPower {

    private static final int height = 3;
    private static final int[] ticksToRotate = {10, 20, 40, 80};
    public byte timerPos = 0;
    private int potteryRotation = 0;
    private double[] offsets = {0.25D, 0.375D, 0.5D, 0.625D};
    private boolean asynchronous = false;
    private int rotationTime = 0;
    private int power;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("SwitchSetting")) {
            this.timerPos = tag.func_74771_c("SwitchSetting");
            if (this.timerPos > 3)
                this.timerPos = 3;
        }
        if (tag.func_74764_b("PotteryRotation"))
            this.potteryRotation = tag.func_74762_e("PotteryRotation");
        if (tag.func_74764_b("Asynchronous"))
            this.asynchronous = tag.func_74767_n("Asynchronous");
        if (tag.func_74764_b("RotationTime"))
            this.rotationTime = tag.func_74762_e("RotationTime");
        this.power = tag.func_74762_e("power");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("PotteryRotation", this.potteryRotation);
        tag.func_74774_a("SwitchSetting", this.timerPos);
        tag.func_74757_a("Asynchronous", this.asynchronous);
        if (this.asynchronous || this.rotationTime != 0)
            tag.func_74768_a("RotationTime", this.rotationTime);
        tag.func_74768_a("power", power);
        return tag;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void func_73660_a() {
        if (!this.getBlockWorld().field_72995_K) {
            this.power = calculateInput();
            if (power > 0) {
                if (!asynchronous && getBlockWorld().func_82737_E() % (long) ticksToRotate[timerPos] == 0) {
                    this.getBlockWorld().func_184133_a(null, field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.05F, 1.0F);
                    rotateTurntable();
                } else if (asynchronous) {
                    rotationTime++;
                    if (rotationTime >= ticksToRotate[timerPos]) {
                        rotationTime = 0;
                        this.getBlockWorld().func_184133_a(null, field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.05F, 1.0F);
                        rotateTurntable();
                    }
                }
            }
        }
    }

    public boolean processRightClick(EntityPlayer player) {
        if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151113_aN) {
                toggleAsynchronous(player);
                return true;
            }
        } else if (player.func_184614_ca().func_190926_b()) {
            advanceTimerPos();
            getBlockWorld().func_180497_b(field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(getBlockWorld()), 5);
            getBlockWorld().func_184133_a(null, field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3F, 0.6F);
            return true;
        }
        return false;
    }

    public void toggleAsynchronous(EntityPlayer player) {
        if (!this.getBlockWorld().func_82736_K().func_82766_b("doDaylightCycle")) {
            if (!asynchronous) {
                this.asynchronous = true;
            } else if (player != null) {
                player.func_146105_b(new TextComponentTranslation("message.bwm:async.unavailable"), false);
            }
        } else {
            boolean isSneaking = player.func_70093_af();
            String isOn = "enabled";
            boolean async = !this.asynchronous;
            if ((!async && !isSneaking) || (async && isSneaking))
                isOn = "disabled";
            player.func_146105_b(new TextComponentTranslation("message.bwm:async." + isOn), false);
            if (!isSneaking) {
                this.getBlockWorld().func_184133_a(null, field_174879_c, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.05F, 1.0F);
                this.asynchronous = async;
            }
        }
    }

    public void rotateTurntable() {
        Rotation rotation = BWMAPI.IMPLEMENTATION.isRedstonePowered(field_145850_b, field_174879_c) ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;

        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(func_174877_v());

        for (int i = 1; i < height; i++) {
            pos.func_185336_p(pos.func_177956_o() + 1);
//            TurntableRotationManager.rotateEntities(world,pos,rotation);
            TurntableRotationManager.IRotation handler = rotateBlock(pos, rotation);
            if (handler == null)
                break;
            if (handler.canTransmitHorizontally(field_145850_b, pos))
                TurntableRotationManager.rotateAttachments(field_145850_b, pos, rotation);
            if (!handler.canTransmitVertically(field_145850_b, pos))
                break;
        }

        getBlockWorld().func_190524_a(pos, BWMBlocks.SINGLE_MACHINES, pos);
    }

    public byte getTimerPos() {
        return timerPos;
    }

    public double getOffset() {
        return offsets[this.timerPos];
    }

    public void advanceTimerPos() {
        timerPos++;
        if (timerPos > 3)
            timerPos = 0;
        IBlockState state = getBlockWorld().func_180495_p(field_174879_c);
        getBlockWorld().func_184138_a(field_174879_c, state, state, 3);
    }

    private TurntableRotationManager.IRotation rotateBlock(BlockPos pos, Rotation rotation) {
        IBlockState input = getBlockWorld().func_180495_p(pos);
        rotateCraftable(field_145850_b, pos, input);
        return TurntableRotationManager.rotate(field_145850_b, pos, rotation);
    }

    private void spawnParticlesAndSound(IBlockState state) {
        if (state.func_185904_a() != Material.field_151579_a) {
            field_145850_b.func_184133_a(null, field_174879_c, state.func_177230_c().getSoundType(state, field_145850_b, field_174879_c, null).func_185841_e(), SoundCategory.BLOCKS, 0.5F, field_145850_b.field_73012_v.nextFloat() * 0.1F + 0.8F);
            ((WorldServer) this.field_145850_b).func_175739_a(EnumParticleTypes.BLOCK_DUST, field_174879_c.func_177958_n() + 0.5, field_174879_c.func_177956_o() + 1, field_174879_c.func_177952_p() + 0.5, 30, 0.0D, 0.5D, 0.0D, 0.15000000596046448D, Block.func_176210_f(state));
        }
    }

    private void rotateCraftable(World world, BlockPos pos, IBlockState input) {
        TurntableRecipe recipe = BWRegistry.TURNTABLE.findRecipe(world, pos, input).orElse(null);
        if (recipe != null) {
            this.potteryRotation++;
            spawnParticlesAndSound(input);
            if (recipe.craftRecipe(world, pos, world.field_73012_v, input))
                this.potteryRotation = 0;
        } else {
            this.potteryRotation = 0;
        }
    }

    @Override
    public int getSubtype() {
        return this.timerPos + 8;
    }

    @Override
    public void setSubtype(int type) {
        this.timerPos = (byte) Math.min(type, 3);
    }


    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing == EnumFacing.DOWN)
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return true;
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return func_145838_q();
    }

    public int getPotteryRotation() {
        return potteryRotation;
    }
}
