package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.BWMod;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.registry.PulleyStructureManager;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailBase.EnumRailDirection;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class TileEntityPulley extends TileEntityVisibleInventory implements IMechanicalPower, IProgressSource {

    private EntityExtendingRope rope;
    private NBTTagCompound ropeTag = null;
    private int power;


    public boolean isPowered() {
        return power > 0;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isRaising() {
        return !BWMAPI.IMPLEMENTATION.isRedstonePowered(field_145850_b, field_174879_c) && isPowered();
    }

    public boolean isLowering() {
        return !BWMAPI.IMPLEMENTATION.isRedstonePowered(field_145850_b, field_174879_c) && !isPowered();
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return super.createItemStackHandler();
    }

    @Override
    public String getName() {
        return "inv.pulley.name";
    }

    @Override
    public int getMaxVisibleSlots() {
        return 4;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int x = field_174879_c.func_177958_n();
        int y = field_174879_c.func_177956_o();
        int z = field_174879_c.func_177952_p();
        return player.func_70092_e(x + 0.5D, y + 0.5D, z + 0.5D) <= 64.0D;
    }

    @Override
    public void func_73660_a() {
        if (this.getBlockWorld().field_72995_K)
            return;
        tryNextOperation();
    }

    private void tryNextOperation() {
        this.power = calculateInput();

        if (!activeOperation() && this.getBlockWorld().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines) {
            if (canGoDown(false)) {
                goDown();
            } else if (canGoUp()) {
                goUp();
            }
        }
    }

    private boolean validRopeConnector(BlockPos pos) {
        IBlockState state = getBlockWorld().func_180495_p(pos);
        return state.func_177230_c() instanceof IRopeConnector && ((IRopeConnector) state.func_177230_c()).getFacing(state) == EnumFacing.UP;
    }

    private boolean canGoUp() {
        if (isRaising()) {
            if (putRope(false)) {
                BlockPos lowest = BlockRope.getLowestRopeBlock(getBlockWorld(), field_174879_c);
                if (!lowest.equals(field_174879_c)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canGoDown(boolean isMoving) {
        if (isLowering()) {
            if (takeRope(false)) {
                BlockPos newPos = BlockRope.getLowestRopeBlock(getBlockWorld(), field_174879_c).func_177977_b();
                IBlockState state = getBlockWorld().func_180495_p(newPos);
                boolean flag = !isMoving && validRopeConnector(newPos);
                if (newPos.func_177956_o() > 0 && (getBlockWorld().func_175623_d(newPos) || state.func_177230_c().func_176200_f(getBlockWorld(), newPos) || flag)
                        && newPos.func_177984_a().func_177956_o() > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private void goUp() {
        BlockPos lowest = BlockRope.getLowestRopeBlock(getBlockWorld(), field_174879_c);
        boolean flag = validRopeConnector(lowest.func_177977_b());
        rope = new EntityExtendingRope(getBlockWorld(), field_174879_c, lowest, lowest.func_177984_a().func_177956_o());
        if (!flag || movePlatform(lowest.func_177977_b(), true)) {
            getBlockWorld().func_184133_a(null, field_174879_c.func_177977_b(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS,
                    0.4F + (getBlockWorld().field_73012_v.nextFloat() * 0.1F), 1.0F);
            getBlockWorld().func_72838_d(rope);
            getBlockWorld().func_175698_g(lowest);
            putRope(true);
        } else {
            rope = null;
        }
    }

    private void goDown() {
        BlockPos newPos = BlockRope.getLowestRopeBlock(getBlockWorld(), field_174879_c).func_177977_b();
        boolean flag = validRopeConnector(newPos);
        rope = new EntityExtendingRope(getBlockWorld(), field_174879_c, newPos.func_177984_a(), newPos.func_177956_o());
        if (!flag || movePlatform(newPos, false)) {
            getBlockWorld().func_72838_d(rope);
        } else {
            rope = null;
        }
    }

    /**
     * Turns the platform into entities and moves them with the rope
     */

    private boolean movePlatform(BlockPos anchor, boolean up) {
        IBlockState state = getBlockWorld().func_180495_p(anchor);
        if (!(state.func_177230_c() instanceof IRopeConnector))
            return false;

        HashSet<BlockPos> platformBlocks = new HashSet<>();
        platformBlocks.add(anchor);
        boolean success;
        BlockPos below = anchor.func_177977_b();
        if (isPlatform(below) && ((IRopeConnector) state.func_177230_c()).canMovePlatforms(field_145850_b, anchor)) {
            success = addToList(platformBlocks, below, up);
        } else {
            success = up || isIgnoreable(below);
        }
        if (!success) {
            return false;
        }

        for (BlockPos blockPos : platformBlocks) {
            Arrays.asList(new BlockPos[]{blockPos.func_177978_c(), blockPos.func_177968_d()}).forEach(p -> {
                if (!platformBlocks.contains(p)) {
                    fixRail(p, EnumRailDirection.ASCENDING_NORTH, EnumRailDirection.ASCENDING_SOUTH);
                }
            });
            Arrays.asList(new BlockPos[]{blockPos.func_177974_f(), blockPos.func_177976_e()}).forEach(p -> {
                if (!platformBlocks.contains(p)) {
                    fixRail(p, EnumRailDirection.ASCENDING_EAST, EnumRailDirection.ASCENDING_WEST);
                }
            });
        }

        if (!getBlockWorld().field_72995_K) {
            for (BlockPos blockPos : platformBlocks) {
                Vec3i offset = blockPos.func_177973_b(anchor.func_177984_a());
                rope.addBlock(offset, getBlockWorld(), blockPos);
                if (isMoveableBlock(blockPos.func_177984_a())) {
                    rope.addBlock(new Vec3i(offset.func_177958_n(), offset.func_177956_o() + 1, offset.func_177952_p()), getBlockWorld(), blockPos.func_177984_a());
                    getBlockWorld().func_175698_g(blockPos.func_177984_a());
                }
                getBlockWorld().func_175698_g(blockPos);
            }
        }

        return true;
    }

    public boolean isIgnoreable(BlockPos pos) {
        return field_145850_b.func_175623_d(pos) || field_145850_b.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public boolean isMoveableBlock(BlockPos pos) {
        IBlockState state = field_145850_b.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150488_af || state.func_177230_c() instanceof BlockRailBase;
    }

    public boolean isPlatform(BlockPos pos) {
        IBlockState state = field_145850_b.func_180495_p(pos);
        return PulleyStructureManager.isPulleyBlock(state);
    }

    @SuppressWarnings("unchecked")
    private void fixRail(BlockPos rail, EnumRailDirection... directions) {
        List<EnumRailDirection> list = Arrays.asList(directions);
        IBlockState state = getBlockWorld().func_180495_p(rail);
        if (getBlockWorld().func_180495_p(rail).func_177230_c() instanceof BlockRailBase) {
            PropertyEnum<EnumRailDirection> shape = null;
            for (IProperty<?> p : state.func_177227_a()) {
                if ("shape".equals(p.func_177701_a()) && p instanceof PropertyEnum<?>) {
                    shape = (PropertyEnum<EnumRailDirection>) p;
                    break;
                }
            }

            if (shape != null) {
                EnumRailDirection currentShape = state.func_177229_b(shape);
                if (list.contains(currentShape)) {
                    getBlockWorld().func_180501_a(rail, state.func_177226_a(shape, flatten(currentShape)), 6);
                }
            } else {
                BWMod.logger.warn(String.format("Rail at %s has no shape?", rail));
            }
        }
    }

    private EnumRailDirection flatten(EnumRailDirection old) {
        switch (old) {
            case ASCENDING_EAST:
            case ASCENDING_WEST:
                return EnumRailDirection.EAST_WEST;
            case ASCENDING_NORTH:
            case ASCENDING_SOUTH:
                return EnumRailDirection.NORTH_SOUTH;
            default:
                return old;
        }
    }

    private boolean addToList(HashSet<BlockPos> set, BlockPos p, boolean up) {
        if (set.size() > GlobalConfig.maxPlatformBlocks)
            return false;
        if (!isPlatform(p)) {
            return true;
        }

        BlockPos blockCheck = up ? p.func_177984_a() : p.func_177977_b();
        if (!(isIgnoreable(blockCheck) || isMoveableBlock(blockCheck) || isPlatform(blockCheck)) && !set.contains(blockCheck))
            return false;

        set.add(p);

        List<BlockPos> fails = new ArrayList<>();

        Arrays.asList(p.func_177984_a(), p.func_177977_b(), p.func_177978_c(), p.func_177968_d(), p.func_177974_f(), p.func_177976_e()).forEach(q -> {
            if (fails.isEmpty() && !set.contains(q)) {
                if (!addToList(set, q, up))
                    fails.add(q);
            }
        });

        return fails.isEmpty();
    }

    private boolean activeOperation() {
        return rope != null && rope.func_70089_S();
    }

    private boolean takeRope(boolean flag) {
        return InvUtils.consumeItemsInInventory(inventory, new ItemStack(BWMBlocks.ROPE), 1, !flag);
    }

    private boolean putRope(boolean flag) {
        return InvUtils.insert(inventory, new ItemStack(BWMBlocks.ROPE, 1), !flag).func_190926_b();
    }

    public boolean onJobCompleted(boolean up, int targetY, EntityExtendingRope theRope) {
        BlockPos ropePos = new BlockPos(field_174879_c.func_177958_n(), targetY - (up ? 1 : 0), field_174879_c.func_177952_p());
        IBlockState state = getBlockWorld().func_180495_p(ropePos);
        if (!up) {
            if ((getBlockWorld().func_175623_d(ropePos) || state.func_177230_c().func_176200_f(getBlockWorld(), ropePos)) && BWMBlocks.ROPE.func_176196_c(getBlockWorld(), ropePos) && takeRope(true)) {
                getBlockWorld().func_184133_a(null, field_174879_c.func_177977_b(), SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.4F, 1.0F);
                getBlockWorld().func_175656_a(ropePos, BWMBlocks.ROPE.func_176223_P());
            } else {
                tryNextOperation();
                theRope.func_70106_y();
                return false;
            }
        }
        if ((theRope.getUp() ? canGoUp() : canGoDown(true)) && !theRope.isPathBlocked()) {
            theRope.setTargetY(targetY + (theRope.getUp() ? 1 : -1));
            if (up) {
                if (!getBlockWorld().func_175623_d(ropePos.func_177984_a())) {
                    getBlockWorld().func_184133_a(null, field_174879_c.func_177977_b(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS,
                            0.4F + (getBlockWorld().field_73012_v.nextFloat() * 0.1F), 1.0F);
                    getBlockWorld().func_175698_g(ropePos.func_177984_a());
                    putRope(true);
                }
            }
            return true;
        } else {
            tryNextOperation();
            theRope.func_70106_y();
            return false;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound ropetag = new NBTTagCompound();
        if (rope != null)
            rope.func_184198_c(ropetag);
        tag.func_74782_a("Rope", ropetag);

        tag.func_74768_a("power", power);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ropeTag = (NBTTagCompound) tag.func_74781_a("Rope");
        this.power = tag.func_74762_e("power");
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (rope == null && !func_145831_w().field_72995_K && ropeTag != null && !ropeTag.func_82582_d()) {
            NBTTagList pos = (NBTTagList) ropeTag.func_74781_a("Pos");
            if (pos != null) {
                rope = (EntityExtendingRope) AnvilChunkLoader.func_186054_a(ropeTag, getBlockWorld(), pos.func_150309_d(0),
                        pos.func_150309_d(1), pos.func_150309_d(2), true);
            }
        }
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.func_176740_k().func_176722_c())
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return true;
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return func_145838_q();
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getProgress() {
        return Math.min(power, 1);
    }


}
