package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.tile.TileBasicInventory;
import betterwithmods.util.DirUtils;
import betterwithmods.util.StackEjector;
import betterwithmods.util.VectorBuilder;
import com.google.common.collect.Lists;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;

public class TileEntityMill extends TileBasicInventory implements ITickable, IMechanicalPower, ICrankable, IProgressSource {
    public boolean blocked;
    public int power;
    public int grindCounter;
    public int grindMax;

    private int increment;


    public TileEntityMill() {
        this.grindCounter = 0;
        this.increment = 1;
    }

    public int getIncrement() {
        return increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public boolean isActive() {
        return power > 0;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public BlockMechMachines getBlock() {
        if (this.func_145838_q() instanceof BlockMechMachines)
            return (BlockMechMachines) this.func_145838_q();
        throw new IllegalStateException("This TileEntity does not have the correct block, something is severely wrong. Report to the mod author immediately");
    }

    private boolean findIfBlocked() {
        int count = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = field_174879_c.func_177972_a(facing);
            IBlockState state = field_145850_b.func_180495_p(offset);
            Material material = state.func_185904_a();
            if (field_145850_b.isSideSolid(offset, facing.func_176734_d()) || (!material.func_76222_j() && !material.func_76218_k())) {
                count++;
            }
        }
        return count > 1;
    }

    public boolean isBlocked() {
        return blocked;
    }

    @Override
    public void func_73660_a() {
        if (this.getBlockWorld().field_72995_K)
            return;

        this.power = calculateInput();
        this.blocked = findIfBlocked();
        getBlock().setActive(field_145850_b, field_174879_c, isActive());

        if (isBlocked()) {
            return;
        }

        if (isActive()) {
            BWRegistry.MILLSTONE.craftRecipe(field_145850_b, this, inventory);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("blocked"))
            this.blocked = tag.func_74767_n("blocked");
        if (tag.func_74764_b("GrindCounter"))
            this.grindCounter = tag.func_74762_e("GrindCounter");
        if (tag.func_74764_b("GrindMax"))
            this.grindMax = tag.func_74762_e("GrindMax");
        if (tag.func_74764_b("increment"))
            this.increment = tag.func_74762_e("increment");
        this.power = tag.func_74762_e("power");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("GrindCounter", this.grindCounter);
        tag.func_74768_a("GrindMax", this.grindMax);
        tag.func_74768_a("power", power);
        tag.func_74768_a("increment", increment);
        tag.func_74757_a("blocked", blocked);
        return tag;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    private boolean canEject(EnumFacing facing) {
        if (field_145850_b.func_175623_d(field_174879_c.func_177972_a(facing)))
            return true;
        return !field_145850_b.func_175665_u(field_174879_c.func_177972_a(facing)) && !field_145850_b.isSideSolid(field_174879_c.func_177972_a(facing), facing.func_176734_d());
    }

    private void ejectStack(ItemStack stack) {
        List<EnumFacing> validDirections = Lists.newArrayList(EnumFacing.field_176754_o).stream().filter(this::canEject).collect(Collectors.toList());
        if (validDirections.isEmpty()) {
            blocked = true;
            return;
        }
        VectorBuilder builder = new VectorBuilder();
        BlockPos offset = field_174879_c.func_177972_a(DirUtils.getRandomFacing(validDirections, getBlockWorld().field_73012_v));
        new StackEjector(field_145850_b, stack, builder.set(offset).rand(0.5f).offset(0.25f).build(), builder.setGaussian(0.05f, 0, 0.05f).build()).ejectStack();
    }

    public void ejectRecipe(NonNullList<ItemStack> output) {
        if (!output.isEmpty()) {
            for (ItemStack anOutput : output) {
                ItemStack stack = anOutput.func_77946_l();
                if (!stack.func_190926_b())
                    ejectStack(stack);
            }
        }
    }


    public boolean isGrinding() {
        return this.grindCounter > 0;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.func_176740_k().func_176720_b())
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
        if (field_145850_b.func_175625_s(field_174879_c.func_177972_a(facing)) instanceof TileCrank) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return true;
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return func_174877_v();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getBlockWorld().func_175625_s(this.field_174879_c) == this && player.func_70092_e(this.field_174879_c.func_177958_n() + 0.5D, this.field_174879_c.func_177956_o() + 0.5D, this.field_174879_c.func_177952_p() + 0.5D) <= 64.0D;
    }

    @Override
    public int getMax() {
        return grindMax;
    }

    @Override
    public int getProgress() {
        return this.grindCounter;
    }

}
